/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.type.StructField;
import smile.data.vector.DoubleVector;

class DoubleVectorImpl
implements DoubleVector {
    private final String name;
    private final Measure measure;
    private final double[] vector;

    public DoubleVectorImpl(String name, double[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public DoubleVectorImpl(StructField field, double[] vector) {
        if (field.measure instanceof CategoricalMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public double[] array() {
        return this.vector;
    }

    @Override
    public double[] toDoubleArray() {
        return this.vector;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        System.arraycopy(this.vector, 0, a, 0, this.vector.length);
        return a;
    }

    @Override
    public double getDouble(int i) {
        return this.vector[i];
    }

    @Override
    public Double get(int i) {
        return this.vector[i];
    }

    @Override
    public DoubleVector get(int ... index) {
        double[] v = new double[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new DoubleVectorImpl(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public DoubleStream stream() {
        return Arrays.stream(this.vector);
    }

    public String toString() {
        return this.toString(10);
    }
}

