/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import smile.data.CategoricalEncoder;
import smile.data.DataFrameImpl;
import smile.data.Dataset;
import smile.data.IndexDataFrame;
import smile.data.Tuple;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.IntVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.math.matrix.Matrix;
import smile.util.Strings;

public interface DataFrame
extends Dataset<Tuple>,
Iterable<BaseVector> {
    public StructType schema();

    default public String[] names() {
        return this.schema().names();
    }

    default public DataType[] types() {
        return this.schema().types();
    }

    default public Measure[] measures() {
        return this.schema().measures();
    }

    default public int nrow() {
        return this.size();
    }

    public int ncol();

    default public DataFrame structure() {
        List<BaseVector> vectors = Arrays.asList(Vector.of("Column", String.class, this.names()), Vector.of("Type", DataType.class, this.types()), Vector.of("Measure", Measure.class, this.measures()));
        return new DataFrameImpl((Collection<BaseVector>)vectors);
    }

    default public DataFrame omitNullRows() {
        return DataFrame.of(this.stream().filter(r -> !r.hasNull()), this.schema().unboxed());
    }

    default public Object get(int i, int j) {
        return ((Tuple)this.get(i)).get(j);
    }

    default public Object get(int i, String column) {
        return ((Tuple)this.get(i)).get(column);
    }

    default public DataFrame of(int ... index) {
        return new IndexDataFrame(this, index);
    }

    default public DataFrame of(boolean ... index) {
        return this.of(IntStream.range(0, index.length).filter(i -> index[i]).toArray());
    }

    default public DataFrame slice(int from, int to) {
        return IntStream.range(from, to).mapToObj(this::get).collect(Collectors.collect());
    }

    default public boolean isNullAt(int i, int j) {
        return ((Tuple)this.get(i)).isNullAt(j);
    }

    default public boolean isNullAt(int i, String column) {
        return ((Tuple)this.get(i)).isNullAt(column);
    }

    default public boolean getBoolean(int i, int j) {
        return ((Tuple)this.get(i)).getBoolean(j);
    }

    default public boolean getBoolean(int i, String column) {
        return ((Tuple)this.get(i)).getBoolean(column);
    }

    default public char getChar(int i, int j) {
        return ((Tuple)this.get(i)).getChar(j);
    }

    default public char getChar(int i, String column) {
        return ((Tuple)this.get(i)).getChar(column);
    }

    default public byte getByte(int i, int j) {
        return ((Tuple)this.get(i)).getByte(j);
    }

    default public byte getByte(int i, String column) {
        return ((Tuple)this.get(i)).getByte(column);
    }

    default public short getShort(int i, int j) {
        return ((Tuple)this.get(i)).getShort(j);
    }

    default public short getShort(int i, String column) {
        return ((Tuple)this.get(i)).getShort(column);
    }

    default public int getInt(int i, int j) {
        return ((Tuple)this.get(i)).getInt(j);
    }

    default public int getInt(int i, String column) {
        return ((Tuple)this.get(i)).getInt(column);
    }

    default public long getLong(int i, int j) {
        return ((Tuple)this.get(i)).getLong(j);
    }

    default public long getLong(int i, String column) {
        return ((Tuple)this.get(i)).getLong(column);
    }

    default public float getFloat(int i, int j) {
        return ((Tuple)this.get(i)).getFloat(j);
    }

    default public float getFloat(int i, String column) {
        return ((Tuple)this.get(i)).getFloat(column);
    }

    default public double getDouble(int i, int j) {
        return ((Tuple)this.get(i)).getDouble(j);
    }

    default public double getDouble(int i, String column) {
        return ((Tuple)this.get(i)).getDouble(column);
    }

    default public String getString(int i, int j) {
        return ((Tuple)this.get(i)).getString(j);
    }

    default public String getString(int i, String column) {
        return ((Tuple)this.get(i)).getString(column);
    }

    default public String toString(int i, int j) {
        Object o = this.get(i, j);
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return this.schema().field(j).toString(o);
    }

    default public String toString(int i, String column) {
        return this.toString(i, this.indexOf(column));
    }

    default public BigDecimal getDecimal(int i, int j) {
        return ((Tuple)this.get(i)).getDecimal(j);
    }

    default public BigDecimal getDecimal(int i, String column) {
        return ((Tuple)this.get(i)).getDecimal(column);
    }

    default public LocalDate getDate(int i, int j) {
        return ((Tuple)this.get(i)).getDate(j);
    }

    default public LocalDate getDate(int i, String column) {
        return ((Tuple)this.get(i)).getDate(column);
    }

    default public LocalTime getTime(int i, int j) {
        return ((Tuple)this.get(i)).getTime(j);
    }

    default public LocalTime getTime(int i, String column) {
        return ((Tuple)this.get(i)).getTime(column);
    }

    default public LocalDateTime getDateTime(int i, int j) {
        return ((Tuple)this.get(i)).getDateTime(j);
    }

    default public LocalDateTime getDateTime(int i, String column) {
        return ((Tuple)this.get(i)).getDateTime(column);
    }

    default public String getScale(int i, int j) {
        int x = this.getInt(i, j);
        Measure measure = this.schema().field((int)j).measure;
        return measure instanceof CategoricalMeasure ? ((CategoricalMeasure)measure).toString(x) : String.valueOf(x);
    }

    default public String getScale(int i, String column) {
        return this.getScale(i, this.indexOf(column));
    }

    default public <T> T[] getArray(int i, int j) {
        return ((Tuple)this.get(i)).getArray(j);
    }

    default public <T> T[] getArray(int i, String column) {
        return ((Tuple)this.get(i)).getArray(column);
    }

    default public Tuple getStruct(int i, int j) {
        return ((Tuple)this.get(i)).getStruct(j);
    }

    default public Tuple getStruct(int i, String column) {
        return ((Tuple)this.get(i)).getStruct(column);
    }

    public int indexOf(String var1);

    default public BaseVector apply(String column) {
        return this.column(column);
    }

    default public BaseVector apply(Enum<?> column) {
        return this.column(column.toString());
    }

    public BaseVector column(int var1);

    default public BaseVector column(String column) {
        return this.column(this.indexOf(column));
    }

    default public BaseVector column(Enum<?> column) {
        return this.column(this.indexOf(column.toString()));
    }

    public <T> Vector<T> vector(int var1);

    default public <T> Vector<T> vector(String column) {
        return this.vector(this.indexOf(column));
    }

    default public <T> Vector<T> vector(Enum<?> column) {
        return this.vector(this.indexOf(column.toString()));
    }

    public BooleanVector booleanVector(int var1);

    default public BooleanVector booleanVector(String column) {
        return this.booleanVector(this.indexOf(column));
    }

    default public BooleanVector booleanVector(Enum<?> column) {
        return this.booleanVector(this.indexOf(column.toString()));
    }

    public CharVector charVector(int var1);

    default public CharVector charVector(String column) {
        return this.charVector(this.indexOf(column));
    }

    default public CharVector charVector(Enum<?> column) {
        return this.charVector(this.indexOf(column.toString()));
    }

    public ByteVector byteVector(int var1);

    default public ByteVector byteVector(String column) {
        return this.byteVector(this.indexOf(column));
    }

    default public ByteVector byteVector(Enum<?> column) {
        return this.byteVector(this.indexOf(column.toString()));
    }

    public ShortVector shortVector(int var1);

    default public ShortVector shortVector(String column) {
        return this.shortVector(this.indexOf(column));
    }

    default public ShortVector shortVector(Enum<?> column) {
        return this.shortVector(this.indexOf(column.toString()));
    }

    public IntVector intVector(int var1);

    default public IntVector intVector(String column) {
        return this.intVector(this.indexOf(column));
    }

    default public IntVector intVector(Enum<?> column) {
        return this.intVector(this.indexOf(column.toString()));
    }

    public LongVector longVector(int var1);

    default public LongVector longVector(String column) {
        return this.longVector(this.indexOf(column));
    }

    default public LongVector longVector(Enum<?> column) {
        return this.longVector(this.indexOf(column.toString()));
    }

    public FloatVector floatVector(int var1);

    default public FloatVector floatVector(String column) {
        return this.floatVector(this.indexOf(column));
    }

    default public FloatVector floatVector(Enum<?> column) {
        return this.floatVector(this.indexOf(column.toString()));
    }

    public DoubleVector doubleVector(int var1);

    default public DoubleVector doubleVector(String column) {
        return this.doubleVector(this.indexOf(column));
    }

    default public DoubleVector doubleVector(Enum<?> column) {
        return this.doubleVector(this.indexOf(column.toString()));
    }

    public StringVector stringVector(int var1);

    default public StringVector stringVector(String column) {
        return this.stringVector(this.indexOf(column));
    }

    default public StringVector stringVector(Enum<?> column) {
        return this.stringVector(this.indexOf(column.toString()));
    }

    public DataFrame select(int ... var1);

    default public DataFrame select(String ... columns) {
        int[] indices = Arrays.stream(columns).mapToInt(this::indexOf).toArray();
        return this.select(indices);
    }

    public DataFrame drop(int ... var1);

    default public DataFrame drop(String ... columns) {
        int[] indices = Arrays.stream(columns).mapToInt(this::indexOf).toArray();
        return this.drop(indices);
    }

    public DataFrame merge(DataFrame ... var1);

    public DataFrame merge(BaseVector ... var1);

    public DataFrame union(DataFrame ... var1);

    default public DataFrame factorize(String ... columns) {
        if (columns.length == 0) {
            columns = (String[])Arrays.stream(this.schema().fields()).filter(field -> field.type.isObject()).map(field -> field.name).toArray(String[]::new);
        }
        int n = this.size();
        HashSet<String> set = new HashSet<String>(Arrays.asList(columns));
        BaseVector[] vectors = (BaseVector[])Arrays.stream(this.names()).map(col -> {
            if (set.contains(col)) {
                int j = this.indexOf((String)col);
                List<String> levels = IntStream.range(0, n).mapToObj(i -> this.getString(i, j)).distinct().sorted().collect(java.util.stream.Collectors.toList());
                NominalScale scale = new NominalScale(levels);
                int[] data = new int[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    String s = this.getString(i2, j);
                    data[i2] = s == null ? -1 : scale.valueOf(s).intValue();
                }
                return IntVector.of(new StructField((String)col, DataTypes.IntegerType, scale), data);
            }
            return this.column((String)col);
        }).toArray(BaseVector[]::new);
        return DataFrame.of(vectors);
    }

    default public double[][] toArray(String ... columns) {
        return this.toArray(false, CategoricalEncoder.LEVEL, columns);
    }

    default public double[][] toArray(boolean bias, CategoricalEncoder encoder, String ... columns) {
        int nrow = this.nrow();
        StructType schema = this.schema();
        if (columns.length == 0) {
            columns = schema.names();
        }
        ArrayList<String> colNames = new ArrayList<String>();
        if (bias) {
            colNames.add("Intercept");
        }
        for (String column : columns) {
            int j = schema.indexOf(column);
            StructField field = schema.field(j);
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                int n = cat.size();
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (k = 1; k < n; ++k) {
                        colNames.add(String.format("%s_%s", field.name, cat.level(k)));
                    }
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (k = 0; k < n; ++k) {
                    colNames.add(String.format("%s_%s", field.name, cat.level(k)));
                }
                continue;
            }
            colNames.add(field.name);
        }
        double[][] matrix = new double[nrow][colNames.size()];
        int j = 0;
        if (bias) {
            ++j;
            for (int i = 0; i < nrow; ++i) {
                matrix[i][0] = 1.0;
            }
        }
        for (String column : columns) {
            int col = schema.indexOf(column);
            StructField field = schema.field(col);
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                int i;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (i = 0; i < nrow; ++i) {
                        k = cat.factor(this.getInt(i, col));
                        if (k <= 0) continue;
                        matrix[i][j + k - 1] = 1.0;
                    }
                    j += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (i = 0; i < nrow; ++i) {
                    k = cat.factor(this.getInt(i, col));
                    matrix[i][j + k] = 1.0;
                }
                j += cat.size();
                continue;
            }
            for (int i = 0; i < nrow; ++i) {
                matrix[i][j] = this.getDouble(i, col);
            }
            ++j;
        }
        return matrix;
    }

    default public Matrix toMatrix() {
        return this.toMatrix(false, CategoricalEncoder.LEVEL, null);
    }

    default public Matrix toMatrix(boolean bias, CategoricalEncoder encoder, String rowNames) {
        int nrow = this.nrow();
        int ncol = this.ncol();
        StructType schema = this.schema();
        ArrayList<String> colNames = new ArrayList<String>();
        if (bias) {
            colNames.add("Intercept");
        }
        for (int j = 0; j < ncol; ++j) {
            StructField field = schema.field(j);
            if (field.name.equals(rowNames)) continue;
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                int n = cat.size();
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (k = 1; k < n; ++k) {
                        colNames.add(String.format("%s_%s", field.name, cat.level(k)));
                    }
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (k = 0; k < n; ++k) {
                    colNames.add(String.format("%s_%s", field.name, cat.level(k)));
                }
                continue;
            }
            colNames.add(field.name);
        }
        Matrix matrix = new Matrix(nrow, colNames.size());
        matrix.colNames(colNames.toArray(new String[0]));
        if (rowNames != null) {
            int j = schema.indexOf(rowNames);
            String[] rows = new String[nrow];
            for (int i = 0; i < nrow; ++i) {
                rows[i] = this.getString(i, j);
            }
            matrix.rowNames(rows);
        }
        int j = 0;
        if (bias) {
            ++j;
            for (int i = 0; i < nrow; ++i) {
                matrix.set(i, 0, 1.0);
            }
        }
        for (int col = 0; col < ncol; ++col) {
            StructField field = schema.field(col);
            if (field.name.equals(rowNames)) continue;
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                int i;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    for (i = 0; i < nrow; ++i) {
                        k = cat.factor(this.getInt(i, col));
                        if (k <= 0) continue;
                        matrix.set(i, j + k - 1, 1.0);
                    }
                    j += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                for (i = 0; i < nrow; ++i) {
                    k = cat.factor(this.getInt(i, col));
                    matrix.set(i, j + k, 1.0);
                }
                j += cat.size();
                continue;
            }
            for (int i = 0; i < nrow; ++i) {
                matrix.set(i, j, this.getDouble(i, col));
            }
            ++j;
        }
        return matrix;
    }

    default public DataFrame summary() {
        int ncol = this.ncol();
        String[] names = this.names();
        DataType[] types = this.types();
        Measure[] measures = this.measures();
        String[] col = new String[ncol];
        double[] min = new double[ncol];
        double[] max = new double[ncol];
        double[] avg = new double[ncol];
        long[] count = new long[ncol];
        int k = 0;
        for (int j = 0; j < ncol; ++j) {
            Object s;
            if (measures[j] instanceof CategoricalMeasure) continue;
            DataType type = types[j];
            if (type.isInt()) {
                s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToInt(Integer::intValue).summaryStatistics() : ((IntStream)this.intVector(j).stream()).summaryStatistics();
                col[k] = names[j];
                min[k] = ((IntSummaryStatistics)s).getMin();
                max[k] = ((IntSummaryStatistics)s).getMax();
                avg[k] = ((IntSummaryStatistics)s).getAverage();
                count[k++] = ((IntSummaryStatistics)s).getCount();
                continue;
            }
            if (type.isLong()) {
                s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToLong(Long::longValue).summaryStatistics() : ((LongStream)this.longVector(j).stream()).summaryStatistics();
                col[k] = names[j];
                min[k] = ((LongSummaryStatistics)s).getMin();
                max[k] = ((LongSummaryStatistics)s).getMax();
                avg[k] = ((LongSummaryStatistics)s).getAverage();
                count[k++] = ((LongSummaryStatistics)s).getCount();
                continue;
            }
            if (type.isFloat()) {
                s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToDouble(Float::doubleValue).summaryStatistics() : ((DoubleStream)this.floatVector(j).stream()).summaryStatistics();
                col[k] = names[j];
                min[k] = ((DoubleSummaryStatistics)s).getMin();
                max[k] = ((DoubleSummaryStatistics)s).getMax();
                avg[k] = ((DoubleSummaryStatistics)s).getAverage();
                count[k++] = ((DoubleSummaryStatistics)s).getCount();
                continue;
            }
            if (type.isDouble()) {
                s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToDouble(Double::doubleValue).summaryStatistics() : ((DoubleStream)this.doubleVector(j).stream()).summaryStatistics();
                col[k] = names[j];
                min[k] = ((DoubleSummaryStatistics)s).getMin();
                max[k] = ((DoubleSummaryStatistics)s).getMax();
                avg[k] = ((DoubleSummaryStatistics)s).getAverage();
                count[k++] = ((DoubleSummaryStatistics)s).getCount();
                continue;
            }
            if (type.isByte()) {
                s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToInt(Byte::intValue).summaryStatistics() : ((IntStream)this.byteVector(j).stream()).summaryStatistics();
                col[k] = names[j];
                min[k] = ((IntSummaryStatistics)s).getMin();
                max[k] = ((IntSummaryStatistics)s).getMax();
                avg[k] = ((IntSummaryStatistics)s).getAverage();
                count[k++] = ((IntSummaryStatistics)s).getCount();
                continue;
            }
            if (!type.isShort()) continue;
            s = type.isObject() ? ((Stream)this.vector(j).stream()).filter(Objects::nonNull).mapToInt(Short::intValue).summaryStatistics() : ((IntStream)this.shortVector(j).stream()).summaryStatistics();
            col[k] = names[j];
            min[k] = ((IntSummaryStatistics)s).getMin();
            max[k] = ((IntSummaryStatistics)s).getMax();
            avg[k] = ((IntSummaryStatistics)s).getAverage();
            count[k++] = ((IntSummaryStatistics)s).getCount();
        }
        return new DataFrameImpl(Vector.of("column", String.class, Arrays.copyOf(col, k)), LongVector.of("count", Arrays.copyOf(count, k)), DoubleVector.of("min", Arrays.copyOf(min, k)), DoubleVector.of("avg", Arrays.copyOf(avg, k)), DoubleVector.of("max", Arrays.copyOf(max, k)));
    }

    @Override
    default public String toString(int numRows) {
        return this.toString(numRows, true);
    }

    default public String toString(int numRows, boolean truncate) {
        int rest;
        int i;
        int maxColWidth;
        StringBuilder sb = new StringBuilder(this.schema().toString());
        sb.append('\n');
        boolean hasMoreData = this.size() > numRows;
        String[] names = this.names();
        int numCols = names.length;
        switch (numCols) {
            case 1: {
                maxColWidth = 78;
                break;
            }
            case 2: {
                maxColWidth = 38;
                break;
            }
            default: {
                maxColWidth = 20;
            }
        }
        int maxColumnWidth = maxColWidth;
        int[] colWidths = new int[numCols];
        for (int i2 = 0; i2 < numCols; ++i2) {
            colWidths[i2] = Math.max(names[i2].length(), 3);
        }
        List rows = this.stream().limit(numRows).map(row -> {
            String[] cells = new String[numCols];
            for (int i = 0; i < numCols; ++i) {
                String str = row.toString(i);
                cells[i] = truncate && str.length() > maxColumnWidth ? str.substring(0, maxColumnWidth - 3) + "..." : str;
            }
            return cells;
        }).collect(java.util.stream.Collectors.toList());
        for (String[] row2 : rows) {
            for (i = 0; i < numCols; ++i) {
                colWidths[i] = Math.max(colWidths[i], row2[i].length());
            }
        }
        String sep = IntStream.of(colWidths).mapToObj(w -> Strings.fill('-', w)).collect(java.util.stream.Collectors.joining("+", "+", "+\n"));
        sb.append(sep);
        StringBuilder header = new StringBuilder();
        header.append('|');
        for (i = 0; i < numCols; ++i) {
            if (truncate) {
                header.append(Strings.leftPad(names[i], colWidths[i], ' '));
            } else {
                header.append(Strings.rightPad(names[i], colWidths[i], ' '));
            }
            header.append('|');
        }
        header.append('\n');
        sb.append(header.toString());
        sb.append(sep);
        for (String[] row3 : rows) {
            StringBuilder line = new StringBuilder();
            line.append('|');
            for (int i3 = 0; i3 < numCols; ++i3) {
                if (truncate) {
                    line.append(Strings.leftPad(row3[i3], colWidths[i3], ' '));
                } else {
                    line.append(Strings.rightPad(row3[i3], colWidths[i3], ' '));
                }
                line.append('|');
            }
            line.append('\n');
            sb.append(line.toString());
        }
        sb.append(sep);
        if (hasMoreData && (rest = this.size() - numRows) > 0) {
            String rowsString = rest == 1 ? "row" : "rows";
            sb.append(String.format("%d more %s...\n", rest, rowsString));
        }
        return sb.toString();
    }

    default public String[][] toStrings(int numRows) {
        return this.toStrings(numRows, true);
    }

    default public String[][] toStrings(int numRows, boolean truncate) {
        String[] names = this.names();
        int numCols = names.length;
        int maxColWidth = numCols == 1 ? 78 : (numCols == 2 ? 38 : 20);
        return (String[][])this.stream().limit(numRows).map(row -> {
            String[] cells = new String[numCols];
            for (int i = 0; i < numCols; ++i) {
                String str = row.toString(i);
                cells[i] = truncate && str.length() > maxColWidth ? str.substring(0, maxColWidth - 3) + "..." : str;
            }
            return cells;
        }).toArray((int x$0) -> new String[x$0][]);
    }

    public static DataFrame of(BaseVector ... vectors) {
        return new DataFrameImpl(vectors);
    }

    public static DataFrame of(double[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        BaseVector[] vectors = new DoubleVector[p];
        for (int j = 0; j < p; ++j) {
            double[] x = new double[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            vectors[j] = DoubleVector.of(names[j], x);
        }
        return DataFrame.of(vectors);
    }

    public static DataFrame of(float[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        BaseVector[] vectors = new FloatVector[p];
        for (int j = 0; j < p; ++j) {
            float[] x = new float[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            vectors[j] = FloatVector.of(names[j], x);
        }
        return DataFrame.of(vectors);
    }

    public static DataFrame of(int[][] data, String ... names) {
        int p = data[0].length;
        if (names == null || names.length == 0) {
            names = (String[])IntStream.range(1, p + 1).mapToObj(i -> "V" + i).toArray(String[]::new);
        }
        BaseVector[] vectors = new IntVector[p];
        for (int j = 0; j < p; ++j) {
            int[] x = new int[data.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                x[i2] = data[i2][j];
            }
            vectors[j] = IntVector.of(names[j], x);
        }
        return DataFrame.of(vectors);
    }

    public static <T> DataFrame of(List<T> data, Class<T> clazz) {
        return new DataFrameImpl(data, clazz);
    }

    public static DataFrame of(Stream<? extends Tuple> data) {
        return new DataFrameImpl(data);
    }

    public static DataFrame of(Stream<? extends Tuple> data, StructType schema) {
        return new DataFrameImpl(data, schema);
    }

    public static DataFrame of(List<? extends Tuple> data) {
        return new DataFrameImpl(data);
    }

    public static DataFrame of(List<? extends Tuple> data, StructType schema) {
        return new DataFrameImpl(data, schema);
    }

    public static <T> DataFrame of(Collection<Map<String, T>> data, StructType schema) {
        List rows = data.stream().map(map -> {
            Object[] row = new Object[schema.length()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = map.get(schema.name(i));
            }
            return Tuple.of(row, schema);
        }).collect(java.util.stream.Collectors.toList());
        return DataFrame.of(rows, schema);
    }

    public static DataFrame of(ResultSet rs) throws SQLException {
        StructType schema = DataTypes.struct(rs);
        ArrayList<Tuple> rows = new ArrayList<Tuple>();
        while (rs.next()) {
            rows.add(Tuple.of(rs, schema));
        }
        return DataFrame.of(rows);
    }

    public static interface Collectors {
        public static <T> Collector<T, List<T>, DataFrame> collect(Class<T> clazz) {
            return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            }, container -> DataFrame.of(container, clazz), new Collector.Characteristics[0]);
        }

        public static Collector<Tuple, List<Tuple>, DataFrame> collect() {
            return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            }, DataFrame::of, new Collector.Characteristics[0]);
        }

        public static Collector<Tuple, List<Tuple>, Matrix> matrix() {
            return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            }, container -> {
                if (container.isEmpty()) {
                    throw new IllegalArgumentException("Empty list of tuples");
                }
                int nrow = container.size();
                int ncol = ((Tuple)container.get(0)).length();
                Matrix m = new Matrix(nrow, ncol);
                for (int i = 0; i < nrow; ++i) {
                    for (int j = 0; j < ncol; ++j) {
                        m.set(i, j, ((Tuple)container.get(i)).getDouble(j));
                    }
                }
                return m;
            }, new Collector.Characteristics[0]);
        }
    }
}

