/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Properties;
import smile.classification.DiscriminantAnalysis;
import smile.classification.QDA;
import smile.math.matrix.Matrix;
import smile.util.IntSet;
import smile.util.Strings;

public class RDA
extends QDA {
    private static final long serialVersionUID = 2L;

    public RDA(double[] priori, double[][] mu, double[][] eigen, Matrix[] scaling) {
        super(priori, mu, eigen, scaling, IntSet.of(priori.length));
    }

    public RDA(double[] priori, double[][] mu, double[][] eigen, Matrix[] scaling, IntSet labels) {
        super(priori, mu, eigen, scaling, labels);
    }

    public static RDA fit(double[][] x, int[] y, Properties params) {
        double alpha = Double.parseDouble(params.getProperty("smile.rda.alpha", "0.9"));
        double[] priori = Strings.parseDoubleArray(params.getProperty("smile.rda.priori"));
        double tol = Double.parseDouble(params.getProperty("smile.rda.tolerance", "1E-4"));
        return RDA.fit(x, y, alpha, priori, tol);
    }

    public static RDA fit(double[][] x, int[] y, double alpha) {
        return RDA.fit(x, y, alpha, null, 1.0E-4);
    }

    public static RDA fit(double[][] x, int[] y, double alpha, double[] priori, double tol) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Invalid regularization factor: " + alpha);
        }
        DiscriminantAnalysis da = DiscriminantAnalysis.fit(x, y, priori, tol);
        int k = da.k;
        int p = da.mean.length;
        Matrix St = DiscriminantAnalysis.St(x, da.mean, k, tol);
        Matrix[] cov = DiscriminantAnalysis.cov(x, y, da.mu, da.ni);
        double[][] eigen = new double[k][];
        Matrix[] scaling = new Matrix[k];
        tol *= tol;
        for (int i = 0; i < k; ++i) {
            Matrix v = cov[i];
            v.add(alpha, 1.0 - alpha, St);
            for (int j = 0; j < p; ++j) {
                if (!(v.get(j, j) < tol)) continue;
                throw new IllegalArgumentException(String.format("Class %d covariance matrix (column %d) is close to singular.", i, j));
            }
            Matrix.EVD evd = v.eigen(false, true, true).sort();
            for (double s : evd.wr) {
                if (!(s < tol)) continue;
                throw new IllegalArgumentException(String.format("Class %d covariance matrix is close to singular.", i));
            }
            eigen[i] = evd.wr;
            scaling[i] = evd.Vr;
        }
        return new RDA(da.priori, da.mu, eigen, scaling, da.labels);
    }
}

