/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import java.util.function.Predicate;
import ro.hasna.ts.math.representation.mp.SelfJoinAbstractMatrixProfileTransformer;
import ro.hasna.ts.math.stat.BothWaySummaryStatistics;
import ro.hasna.ts.math.type.MatrixProfile;

public class StompTransformer
extends SelfJoinAbstractMatrixProfileTransformer {
    private static final long serialVersionUID = 2910211807207716085L;

    public StompTransformer(int window) {
        super(window);
    }

    public StompTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        super(window, exclusionZonePercentage, useNormalization);
    }

    @Override
    protected MatrixProfile computeNormalizedMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int i;
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] distanceProfile = new double[n];
        double[] productSums = new double[n];
        BothWaySummaryStatistics first = new BothWaySummaryStatistics();
        BothWaySummaryStatistics second = new BothWaySummaryStatistics();
        for (i = 0; i < this.window; ++i) {
            first.addValue(input[i]);
            second.addValue(input[i + skip]);
        }
        this.computeFirstNormalizedDistanceProfile(input, first, input, second, skip, n, productSums, distanceProfile);
        this.updateMatrixProfileFromDistanceProfile(distanceProfile, 0, skip, n, mp, callback);
        for (i = 1; i < n - skip; ++i) {
            this.computeNextNormalizedDistanceProfile(input, skip, n, distanceProfile, productSums, first, second, i);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, i, skip, n, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    private void computeNextNormalizedDistanceProfile(double[] input, int skip, int n, double[] distanceProfile, double[] productSums, BothWaySummaryStatistics first, BothWaySummaryStatistics second, int i) {
        first.addValue(input[i + this.window - 1]);
        first.removeValue(input[i - 1]);
        BothWaySummaryStatistics secondClone = second.clone();
        for (int j = n - 1; j >= i + skip; --j) {
            if (j < n - 1) {
                secondClone.removeValue(input[j + this.window]);
                secondClone.addValue(input[j]);
            }
            double prev = input[i - 1] * input[j - 1];
            double next = input[i + this.window - 1] * input[j + this.window - 1];
            productSums[j] = productSums[j - 1] - prev + next;
            distanceProfile[j] = this.computeNormalizedDistance(productSums[j], first, secondClone);
        }
    }

    @Override
    protected MatrixProfile computeMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] distanceProfile = new double[n];
        this.computeFirstDistanceProfileWithProductSums(input, input, skip, n, distanceProfile);
        this.updateMatrixProfileFromDistanceProfile(distanceProfile, 0, skip, n, mp, callback);
        for (int i = 1; i < n - skip; ++i) {
            this.computeNextDistanceProfile(input, n, skip, distanceProfile, i);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, i, skip, n, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    private void computeNextDistanceProfile(double[] input, int n, int skip, double[] prevDistanceProfile, int i) {
        for (int j = n - 1; j >= i + skip; --j) {
            double prev = input[i - 1] - input[j - 1];
            double next = input[i + this.window - 1] - input[j + this.window - 1];
            prevDistanceProfile[j] = prevDistanceProfile[j - 1] - prev * prev + next * next;
        }
    }
}

