/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import java.util.function.Predicate;
import org.apache.commons.math3.complex.Complex;
import ro.hasna.ts.math.representation.mp.SelfJoinAbstractMatrixProfileTransformer;
import ro.hasna.ts.math.stat.BothWaySummaryStatistics;
import ro.hasna.ts.math.type.MatrixProfile;

public class StampTransformer
extends SelfJoinAbstractMatrixProfileTransformer {
    private static final long serialVersionUID = 5919724985496947961L;

    public StampTransformer(int window) {
        super(window);
    }

    public StampTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        super(window, exclusionZonePercentage, useNormalization);
    }

    @Override
    protected MatrixProfile computeNormalizedMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] distanceProfile = new double[n];
        int[] indices = this.generateRandomIndices(n);
        for (int i = 0; i < n; ++i) {
            int index = indices[i];
            this.computeNormalizedDistanceProfileWithFft(input, index, input, skip, n, distanceProfile);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, n, index, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    protected void updateMatrixProfileFromDistanceProfile(double[] distanceProfile, int n, int i, MatrixProfile mp, Predicate<MatrixProfile> callback) {
        for (int j = 0; j < n; ++j) {
            if (mp.getProfile()[j] > distanceProfile[j]) {
                mp.getProfile()[j] = distanceProfile[j];
                mp.getIndexProfile()[j] = i;
            }
            if (!(mp.getProfile()[i] > distanceProfile[j])) continue;
            mp.getProfile()[i] = distanceProfile[j];
            mp.getIndexProfile()[i] = j;
        }
        this.executeCallback(callback, mp);
    }

    @Override
    protected MatrixProfile computeMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] distanceProfile = new double[n];
        int[] indices = this.generateRandomIndices(n);
        for (int i = 0; i < n; ++i) {
            int index = indices[i];
            this.computeDistanceProfileWithProductSums(input, index, input, skip, n, distanceProfile);
            this.updateMatrixProfileFromDistanceProfile(distanceProfile, n, index, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    protected void computeDistanceProfileWithProductSums(double[] a, int i, double[] b, int skip, int nb, double[] distanceProfile) {
        for (int j = 0; j < nb; ++j) {
            if (this.inExclusionZone(i, j, skip)) {
                distanceProfile[j] = Double.POSITIVE_INFINITY;
                continue;
            }
            double distance = 0.0;
            for (int k = 0; k < this.window; ++k) {
                distance += (a[k + i] - b[k + j]) * (a[k + i] - b[k + j]);
            }
            distanceProfile[j] = distance;
        }
    }

    protected void computeNormalizedDistanceProfileWithFft(double[] a, int i, double[] b, int skip, int nb, double[] distanceProfile) {
        BothWaySummaryStatistics first = new BothWaySummaryStatistics();
        BothWaySummaryStatistics second = new BothWaySummaryStatistics();
        for (int k = 0; k < this.window; ++k) {
            first.addValue(a[k + i]);
            second.addValue(b[k]);
        }
        Complex[] transform = this.computeConvolutionUsingFft(a, i, b);
        for (int j = 0; j < nb; ++j) {
            if (j > 0) {
                second.addValue(b[j + this.window - 1]);
                second.removeValue(b[j - 1]);
            }
            if (this.inExclusionZone(i, j, skip)) {
                distanceProfile[j] = Double.POSITIVE_INFINITY;
                continue;
            }
            double productSum = transform[j + this.window - 1].getReal();
            distanceProfile[j] = this.computeNormalizedDistance(productSum, first, second);
        }
    }
}

