/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import java.util.function.Predicate;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.exception.CancellationException;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.representation.mp.AbstractMatrixProfileTransformer;
import ro.hasna.ts.math.type.MatrixProfile;

public abstract class SelfJoinAbstractMatrixProfileTransformer
extends AbstractMatrixProfileTransformer
implements GenericTransformer<double[], MatrixProfile> {
    private static final long serialVersionUID = 4273395812927663256L;

    public SelfJoinAbstractMatrixProfileTransformer(int window) {
        this(window, 0.25, true);
    }

    public SelfJoinAbstractMatrixProfileTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        super(window, exclusionZonePercentage, useNormalization);
        int skip = (int)((double)window * exclusionZonePercentage);
        if (skip < 1) {
            int minWindow = (int)Math.ceil(1.0 / exclusionZonePercentage);
            throw new NumberIsTooSmallException(window, (Number)minWindow, true);
        }
    }

    @Override
    public MatrixProfile transform(double[] input) {
        int len = input.length;
        int skip = (int)((double)this.window * this.exclusionZonePercentage);
        if (len < this.window + skip) {
            throw new ArrayLengthIsTooSmallException(len, (Number)(this.window + skip), true);
        }
        if (this.useNormalization) {
            return this.computeNormalizedMatrixProfile(input, skip, null);
        }
        return this.computeMatrixProfile(input, skip, null);
    }

    public void transform(double[] input, Predicate<MatrixProfile> callback) {
        int len = input.length;
        int skip = (int)((double)this.window * this.exclusionZonePercentage);
        if (len < this.window + skip) {
            throw new ArrayLengthIsTooSmallException(len, (Number)(this.window + skip), true);
        }
        if (this.useNormalization) {
            this.computeNormalizedMatrixProfile(input, skip, callback);
        } else {
            this.computeMatrixProfile(input, skip, callback);
        }
    }

    protected void updateMatrixProfileWithSqrt(MatrixProfile mp) {
        double[] profile = mp.getProfile();
        for (int i = 0; i < profile.length; ++i) {
            profile[i] = FastMath.sqrt(profile[i]);
        }
    }

    protected void updateMatrixProfileFromDistanceProfile(double[] distanceProfile, int i, int skip, int n, MatrixProfile mp, Predicate<MatrixProfile> callback) {
        for (int j = i + skip; j < n; ++j) {
            if (mp.getProfile()[j] > distanceProfile[j]) {
                mp.getProfile()[j] = distanceProfile[j];
                mp.getIndexProfile()[j] = i;
            }
            if (!(mp.getProfile()[i] > distanceProfile[j])) continue;
            mp.getProfile()[i] = distanceProfile[j];
            mp.getIndexProfile()[i] = j;
        }
        this.executeCallback(callback, mp);
    }

    protected void executeCallback(Predicate<MatrixProfile> callback, MatrixProfile mp) {
        if (callback == null) {
            return;
        }
        MatrixProfile clone = mp.clone();
        this.updateMatrixProfileWithSqrt(clone);
        if (!callback.test(clone)) {
            throw new CancellationException();
        }
    }

    protected abstract MatrixProfile computeNormalizedMatrixProfile(double[] var1, int var2, Predicate<MatrixProfile> var3);

    protected abstract MatrixProfile computeMatrixProfile(double[] var1, int var2, Predicate<MatrixProfile> var3);
}

