/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation.mp;

import java.util.function.Predicate;
import ro.hasna.ts.math.representation.mp.SelfJoinAbstractMatrixProfileTransformer;
import ro.hasna.ts.math.stat.BothWaySummaryStatistics;
import ro.hasna.ts.math.type.MatrixProfile;

public class ScrimpTransformer
extends SelfJoinAbstractMatrixProfileTransformer {
    private static final long serialVersionUID = -7360923839319598742L;

    public ScrimpTransformer(int window) {
        super(window);
    }

    public ScrimpTransformer(int window, double exclusionZonePercentage, boolean useNormalization) {
        super(window, exclusionZonePercentage, useNormalization);
    }

    @Override
    protected MatrixProfile computeNormalizedMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] distanceProfile = new double[n];
        double[] productSums = new double[n];
        BothWaySummaryStatistics first = new BothWaySummaryStatistics();
        BothWaySummaryStatistics second = new BothWaySummaryStatistics();
        for (int i = 0; i < this.window; ++i) {
            first.addValue(input[i]);
            second.addValue(input[i + skip]);
        }
        this.computeFirstNormalizedDistanceProfile(input, first, input, second, skip, n, productSums, distanceProfile);
        this.updateMatrixProfileFromDistanceProfile(distanceProfile, 0, skip, n, mp, callback);
        int numDiagonals = n - skip - 1;
        int[] indices = this.generateRandomIndices(numDiagonals);
        for (int i = 0; i < numDiagonals; ++i) {
            int indexB = indices[i] + skip;
            this.computeNextNormalizedDistanceProfile(input, input, indexB, n, productSums[indexB], distanceProfile);
            this.updateMatrixProfileFromDiagonalDistanceProfile(distanceProfile, indexB, n, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    protected void computeNextNormalizedDistanceProfile(double[] a, double[] b, int indexB, int n, double prevProductSum, double[] distanceProfile) {
        BothWaySummaryStatistics first = new BothWaySummaryStatistics();
        int indexA = 0;
        BothWaySummaryStatistics second = new BothWaySummaryStatistics();
        for (int k = 0; k < this.window; ++k) {
            first.addValue(a[indexA + k]);
            second.addValue(b[indexB + k]);
        }
        while (indexB < n - 1) {
            first.removeValue(a[indexA]);
            second.removeValue(b[indexB]);
            first.addValue(a[indexA + this.window]);
            second.addValue(b[indexB + this.window]);
            prevProductSum = prevProductSum - a[indexA] * b[indexB] + a[indexA + this.window] * b[indexB + this.window];
            ++indexA;
            distanceProfile[++indexB] = this.computeNormalizedDistance(prevProductSum, first, second);
        }
    }

    protected void updateMatrixProfileFromDiagonalDistanceProfile(double[] distanceProfile, int indexB, int n, MatrixProfile mp, Predicate<MatrixProfile> callback) {
        int indexA = 0;
        while (indexB < n - 1) {
            ++indexA;
            ++indexB;
            if (mp.getProfile()[indexB] > distanceProfile[indexB]) {
                mp.getProfile()[indexB] = distanceProfile[indexB];
                mp.getIndexProfile()[indexB] = indexA;
            }
            if (!(mp.getProfile()[indexA] > distanceProfile[indexB])) continue;
            mp.getProfile()[indexA] = distanceProfile[indexB];
            mp.getIndexProfile()[indexA] = indexB;
        }
        this.executeCallback(callback, mp);
    }

    @Override
    protected MatrixProfile computeMatrixProfile(double[] input, int skip, Predicate<MatrixProfile> callback) {
        int n = input.length - this.window + 1;
        MatrixProfile mp = new MatrixProfile(n);
        double[] firstDistanceProfile = new double[n];
        double[] distanceProfile = new double[n];
        this.computeFirstDistanceProfileWithProductSums(input, input, skip, n, firstDistanceProfile);
        this.updateMatrixProfileFromDistanceProfile(firstDistanceProfile, 0, skip, n, mp, callback);
        int numDiagonals = n - skip - 1;
        int[] indices = this.generateRandomIndices(numDiagonals);
        for (int i = 0; i < numDiagonals; ++i) {
            int indexB = indices[i] + skip;
            this.computeNextDistanceProfile(input, input, indexB, n, firstDistanceProfile[indexB], distanceProfile);
            this.updateMatrixProfileFromDiagonalDistanceProfile(distanceProfile, indexB, n, mp, callback);
        }
        this.updateMatrixProfileWithSqrt(mp);
        return mp;
    }

    protected void computeNextDistanceProfile(double[] a, double[] b, int indexB, int n, double prevDistance, double[] distanceProfile) {
        int indexA = 0;
        while (indexB < n - 1) {
            double prev = a[indexA] - b[indexB];
            double next = a[indexA + this.window] - b[indexB + this.window];
            prevDistance = prevDistance - prev * prev + next * next;
            ++indexA;
            distanceProfile[++indexB] = prevDistance;
        }
    }
}

