/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import org.apache.commons.math3.exception.DimensionMismatchException;
import ro.hasna.ts.math.distribution.DistributionDivider;
import ro.hasna.ts.math.distribution.NormalDistributionDivider;
import ro.hasna.ts.math.normalization.Normalizer;
import ro.hasna.ts.math.normalization.ZNormalizer;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.representation.PiecewiseAggregateApproximation;
import ro.hasna.ts.math.type.SaxPair;

public class IndexableSymbolicAggregateApproximation
implements GenericTransformer<double[], SaxPair[]> {
    private static final long serialVersionUID = -1652621695908903282L;
    private final PiecewiseAggregateApproximation paa;
    private final Normalizer normalizer;
    private final DistributionDivider distributionDivider;
    private final int[] alphabetSizes;

    public IndexableSymbolicAggregateApproximation(int segments, int[] alphabetSizes) {
        this(new PiecewiseAggregateApproximation(segments), new ZNormalizer(), alphabetSizes, new NormalDistributionDivider());
    }

    public IndexableSymbolicAggregateApproximation(PiecewiseAggregateApproximation paa, Normalizer normalizer, int[] alphabetSizes, DistributionDivider distributionDivider) {
        if (paa.getSegments() != alphabetSizes.length) {
            throw new DimensionMismatchException(alphabetSizes.length, paa.getSegments());
        }
        this.paa = paa;
        this.normalizer = normalizer;
        this.alphabetSizes = alphabetSizes;
        this.distributionDivider = distributionDivider;
    }

    @Override
    public SaxPair[] transform(double[] values) {
        double[] copy = this.paa.transform(values);
        if (this.normalizer != null) {
            copy = this.normalizer.normalize(copy);
        }
        int n = 0;
        int segments = copy.length;
        SaxPair[] result = new SaxPair[segments];
        for (int i = 0; i < segments; ++i) {
            double item = copy[i];
            int alphabetSize = this.alphabetSizes[i];
            double[] breakpoints = this.distributionDivider.getBreakpoints(alphabetSize);
            boolean found = false;
            for (int j = 0; j < breakpoints.length && !found; ++j) {
                double breakpoint = breakpoints[j];
                if (!(breakpoint > item)) continue;
                result[n] = new SaxPair(j, alphabetSize);
                found = true;
            }
            if (!found) {
                result[n] = new SaxPair(breakpoints.length, alphabetSize);
            }
            ++n;
        }
        return result;
    }

    public double[] getBreakpoints(int areas) {
        return this.distributionDivider.getBreakpoints(areas);
    }
}

