/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import ro.hasna.ts.math.representation.GenericTransformer;

public class DiscreteHaarWaveletTransform
implements GenericTransformer<double[], double[]> {
    private static final long serialVersionUID = -7596019215266231225L;

    @Override
    public double[] transform(double[] values) {
        double[] copy = new double[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        double[] output = new double[copy.length];
        for (int length = copy.length >> 1; length > 0; length >>= 1) {
            for (int i = 0; i < length; ++i) {
                double sum = copy[i * 2] + copy[i * 2 + 1];
                double difference = copy[i * 2] - copy[i * 2 + 1];
                output[i] = sum;
                output[length + i] = difference;
            }
            if (length <= 1) continue;
            System.arraycopy(output, 0, copy, 0, length << 1);
        }
        return output;
    }
}

