/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import ro.hasna.ts.math.exception.ArrayLengthIsTooSmallException;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.type.MeanLastPair;
import ro.hasna.ts.math.util.TimeSeriesPrecision;

public class AdaptivePiecewiseConstantApproximation
implements GenericTransformer<double[], MeanLastPair[]> {
    private static final long serialVersionUID = 5071554004881637993L;
    private final int segments;
    private final boolean approximateError;

    public AdaptivePiecewiseConstantApproximation(int segments) {
        this(segments, true);
    }

    public AdaptivePiecewiseConstantApproximation(int segments, boolean approximateError) {
        if (segments < 1) {
            throw new NumberIsTooSmallException(segments, (Number)1, true);
        }
        this.segments = segments;
        this.approximateError = approximateError;
    }

    @Override
    public MeanLastPair[] transform(double[] values) {
        int numberOfSegments;
        int length = values.length;
        if (length < 2 * this.segments) {
            throw new ArrayLengthIsTooSmallException(length, (Number)(2 * this.segments), true);
        }
        Segment first = this.createSegments(values, length);
        if (numberOfSegments > this.segments) {
            TreeSet<Segment> set = this.createSegmentsSet(values, first);
            for (numberOfSegments = length / 2; numberOfSegments > this.segments; --numberOfSegments) {
                double mean;
                Segment minSegment = set.pollFirst();
                minSegment.mean = this.getUnifiedMean(minSegment, minSegment.next);
                minSegment.error = this.getUnifiedError(minSegment, minSegment.next, values, minSegment.mean);
                minSegment.end = minSegment.next.end;
                this.deleteSubsequentSegment(minSegment, set);
                if (minSegment.next != null) {
                    mean = this.getUnifiedMean(minSegment, minSegment.next);
                    minSegment.errorWithNext = this.getUnifiedError(minSegment, minSegment.next, values, mean);
                    set.add(minSegment);
                }
                if (minSegment.prev == null) continue;
                set.remove(minSegment.prev);
                mean = this.getUnifiedMean(minSegment.prev, minSegment);
                minSegment.prev.errorWithNext = this.getUnifiedError(minSegment.prev, minSegment, values, mean);
                set.add(minSegment.prev);
            }
        }
        return this.getMeanLastPairs(first, numberOfSegments);
    }

    private Segment createSegments(double[] values, int length) {
        Segment first = null;
        Segment last = null;
        for (int i = 0; i < length - 1; i += 2) {
            double mean = (values[i] + values[i + 1]) / 2.0;
            Segment segment = new Segment(i, i + 2, mean, 2.0 * FastMath.abs(values[i] - mean));
            if (first == null) {
                last = first = segment;
                continue;
            }
            last.next = segment;
            segment.prev = last;
            last = last.next;
        }
        return first;
    }

    private TreeSet<Segment> createSegmentsSet(double[] values, Segment first) {
        TreeSet<Segment> map = new TreeSet<Segment>((s1, s2) -> Precision.compareTo(s1.errorWithNext, s2.errorWithNext, TimeSeriesPrecision.EPSILON));
        Segment current = first;
        while (current.next != null) {
            double mean = this.getUnifiedMean(current, current.next);
            current.errorWithNext = this.getUnifiedError(current, current.next, values, mean);
            map.add(current);
            current = current.next;
        }
        return map;
    }

    private void deleteSubsequentSegment(Segment segment, Set<Segment> set) {
        Segment toBeDeleted = segment.next;
        segment.next = toBeDeleted.next;
        if (toBeDeleted.next != null) {
            toBeDeleted.next.prev = segment;
        }
        set.remove(toBeDeleted);
    }

    private MeanLastPair[] getMeanLastPairs(Segment segment, int numberOfSegments) {
        MeanLastPair[] result = new MeanLastPair[numberOfSegments];
        for (int i = 0; i < numberOfSegments && segment != null; ++i) {
            result[i] = new MeanLastPair(segment.mean, segment.end);
            segment = segment.next;
        }
        return result;
    }

    private double getUnifiedApproximatedError(Segment first, Segment second, double mean) {
        return first.error + second.error + 2.0 * FastMath.abs(first.mean - mean) * (double)(first.end - first.start);
    }

    private double getUnifiedError(Segment first, Segment second, double[] values, double mean) {
        if (Precision.equals(mean, first.mean, TimeSeriesPrecision.EPSILON)) {
            return first.error + second.error;
        }
        if (this.approximateError) {
            return this.getUnifiedApproximatedError(first, second, mean);
        }
        double error = 0.0;
        for (int i = first.start; i < second.end; ++i) {
            error += FastMath.abs(values[i] - mean);
        }
        return error;
    }

    private double getUnifiedMean(Segment first, Segment second) {
        return (first.mean * (double)(first.end - first.start) + second.mean * (double)(second.end - second.start)) / (double)(second.end - first.start);
    }

    private static class Segment {
        int start;
        int end;
        double mean;
        double error;
        double errorWithNext;
        Segment next;
        Segment prev;

        Segment(int start, int end, double mean, double error) {
            this.start = start;
            this.end = end;
            this.mean = mean;
            this.error = error;
            this.errorWithNext = Double.POSITIVE_INFINITY;
        }
    }
}

