/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.representation.SymbolicAggregateApproximation;

public class SaxEuclideanDistance
implements GenericDistanceMeasure<int[]> {
    private static final long serialVersionUID = -2580188567848020545L;
    private final SymbolicAggregateApproximation sax;

    public SaxEuclideanDistance(SymbolicAggregateApproximation sax) {
        this.sax = sax;
    }

    @Override
    public double compute(int[] a, int[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(int[] a, int[] b, double cutoff) {
        double[] breakpoints = this.sax.getBreakpoints();
        double sum = 0.0;
        int w = a.length;
        double transformedCutoff = cutoff * cutoff;
        for (int i = 0; i < w; ++i) {
            double aux;
            int sa = a[i];
            int sb = b[i];
            if (FastMath.abs(sa - sb) <= 1 || !((sum += (aux = sa > sb ? breakpoints[sa - 1] - breakpoints[sb] : breakpoints[sb - 1] - breakpoints[sa]) * aux) >= transformedCutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return FastMath.sqrt(sum);
    }
}

