/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import java.util.Comparator;
import java.util.PriorityQueue;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.representation.mp.MatrixProfileTransformer;
import ro.hasna.ts.math.type.FullMatrixProfile;

public class MatrixProfileDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = -2290780320746907899L;
    private final MatrixProfileTransformer matrixProfileTransformer;
    private final double kPercentage;

    public MatrixProfileDistance(int window) {
        this(new MatrixProfileTransformer(window), 0.05);
    }

    public MatrixProfileDistance(MatrixProfileTransformer matrixProfileTransformer, double kPercentage) {
        this.matrixProfileTransformer = matrixProfileTransformer;
        this.kPercentage = kPercentage;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        FullMatrixProfile fmp = this.matrixProfileTransformer.fullJoinTransform(a, b);
        double[] leftProfile = fmp.getLeftMatrixProfile().getProfile();
        double[] rightProfile = fmp.getRightMatrixProfile().getProfile();
        int k = Math.max(1, (int)(this.kPercentage * (double)(leftProfile.length + rightProfile.length)));
        PriorityQueue<Double> maxHeap = new PriorityQueue<Double>(Comparator.reverseOrder());
        this.updateMaxHeap(leftProfile, k, maxHeap);
        this.updateMaxHeap(rightProfile, k, maxHeap);
        return maxHeap.peek();
    }

    private void updateMaxHeap(double[] profile, int k, PriorityQueue<Double> maxHeap) {
        for (double v : profile) {
            if (maxHeap.size() < k) {
                maxHeap.add(v);
                continue;
            }
            if (!(v < maxHeap.peek())) continue;
            maxHeap.poll();
            maxHeap.add(v);
        }
    }
}

