/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import ro.hasna.ts.math.exception.util.LocalizableMessages;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;

public class LongestCommonSubsequenceDistance
implements GenericDistanceMeasure<double[]> {
    private static final long serialVersionUID = 4542559569313251930L;
    private final double epsilon;
    private final double radiusPercentage;

    public LongestCommonSubsequenceDistance(double epsilon, double radiusPercentage) {
        this.epsilon = epsilon;
        if (radiusPercentage < 0.0 || radiusPercentage > 1.0) {
            throw new OutOfRangeException(LocalizableMessages.OUT_OF_RANGE_BOTH_INCLUSIVE, (Number)radiusPercentage, 0, 1);
        }
        this.radiusPercentage = radiusPercentage;
    }

    @Override
    public double compute(double[] a, double[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(double[] a, double[] b, double cutOffValue) {
        int lcs;
        int n = a.length;
        int radius = (int)((double)n * this.radiusPercentage);
        double min = -1.0;
        if (cutOffValue < 1.0) {
            min = (double)n * (1.0 - cutOffValue);
        }
        if ((lcs = this.computeLcs(a, b, n, radius, min)) == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0 - (double)lcs * 1.0 / (double)n;
    }

    private int computeLcs(double[] a, double[] b, int n, int radius, double min) {
        min = min - (double)n + 1.0;
        int w = 2 * radius + 1;
        int[] prev = new int[w];
        int[] current = new int[w];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            k = FastMath.max(0, radius - i);
            int start = FastMath.max(0, i - radius);
            int end = FastMath.min(n - 1, i + radius);
            int j = start;
            while (j <= end) {
                if (Precision.equals(a[i], b[j], this.epsilon)) {
                    current[k] = prev[k] + 1;
                } else {
                    int x = k - 1 >= 0 ? current[k - 1] : 0;
                    int y = k + 1 < w ? prev[k + 1] : 0;
                    current[k] = FastMath.max(x, y);
                }
                ++j;
                ++k;
            }
            if ((double)(current[k - 1] - i) <= min) {
                return -1;
            }
            System.arraycopy(current, 0, prev, 0, w);
        }
        return current[k - 1];
    }
}

