/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.representation.IndexableSymbolicAggregateApproximation;
import ro.hasna.ts.math.type.SaxPair;

public class IndexableSaxEuclideanDistance
implements GenericDistanceMeasure<SaxPair[]> {
    private static final long serialVersionUID = -4740907293933039859L;
    private final IndexableSymbolicAggregateApproximation isax;

    public IndexableSaxEuclideanDistance(IndexableSymbolicAggregateApproximation isax) {
        this.isax = isax;
    }

    @Override
    public double compute(SaxPair[] a, SaxPair[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(SaxPair[] symbolsA, SaxPair[] symbolsB, double cutoff) {
        double sum = 0.0;
        int w = symbolsA.length;
        double transformedCutoff = cutoff * cutoff;
        for (int i = 0; i < w; ++i) {
            double[] boundsA = this.getBounds(symbolsA[i]);
            double[] boundsB = this.getBounds(symbolsB[i]);
            double diff = 0.0;
            if (boundsA[1] != Double.POSITIVE_INFINITY && boundsB[0] != Double.NEGATIVE_INFINITY && boundsA[1] < boundsB[0]) {
                diff = boundsA[1] - boundsB[0];
            } else if (boundsA[0] != Double.NEGATIVE_INFINITY && boundsB[1] != Double.POSITIVE_INFINITY && boundsA[0] > boundsB[1]) {
                diff = boundsA[0] - boundsB[1];
            }
            sum += diff * diff;
            if (!(sum >= transformedCutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return FastMath.sqrt(sum);
    }

    private double[] getBounds(SaxPair saxPair) {
        double[] bounds = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] breakpoints = this.isax.getBreakpoints(saxPair.getAlphabetSize());
        int symbol = saxPair.getSymbol();
        if (symbol == 0) {
            bounds[1] = breakpoints[0];
        } else if (symbol == breakpoints.length) {
            bounds[0] = breakpoints[symbol - 1];
        } else {
            bounds[0] = breakpoints[symbol - 1];
            bounds[1] = breakpoints[symbol];
        }
        return bounds;
    }
}

