/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.ml.distance;

import org.apache.commons.math3.util.FastMath;
import ro.hasna.ts.math.ml.distance.GenericDistanceMeasure;
import ro.hasna.ts.math.type.MeanLastPair;

public class ApcaEuclideanDistance
implements GenericDistanceMeasure<MeanLastPair[]> {
    private static final long serialVersionUID = -5281044546933045617L;

    @Override
    public double compute(MeanLastPair[] a, MeanLastPair[] b) {
        return this.compute(a, b, Double.POSITIVE_INFINITY);
    }

    @Override
    public double compute(MeanLastPair[] a, MeanLastPair[] b, double cutOffValue) {
        double sum = 0.0;
        int w = a.length;
        double transformedCutoff = cutOffValue * cutOffValue;
        int i = 0;
        int j = 0;
        int pos = 0;
        while (i < w && j < w) {
            double aux = a[i].getMean() - b[j].getMean();
            aux *= aux;
            if (a[i].getLast() == b[j].getLast()) {
                aux *= (double)(a[i].getLast() - pos);
                pos = a[i].getLast();
                ++i;
                ++j;
            } else if (a[i].getLast() < b[j].getLast()) {
                aux *= (double)(a[i].getLast() - pos);
                pos = a[i].getLast();
                ++i;
            } else {
                aux *= (double)(b[j].getLast() - pos);
                pos = b[j].getLast();
                ++j;
            }
            if (!((sum += aux) >= transformedCutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return FastMath.sqrt(sum);
    }
}

