/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.filter;

import org.apache.commons.math3.exception.DimensionMismatchException;
import ro.hasna.ts.math.filter.Filter;

public class MovingAverageFilter
implements Filter {
    private static final long serialVersionUID = -7876483245195295513L;
    private final int observations;
    private final boolean symmetric;
    private final double[] weights;

    public MovingAverageFilter(int observations) {
        this(observations, true, null);
    }

    public MovingAverageFilter(int observations, boolean symmetric, double[] weights) {
        this.observations = observations;
        this.symmetric = symmetric;
        if (weights != null) {
            if (!symmetric && weights.length != observations) {
                throw new DimensionMismatchException(weights.length, observations);
            }
            if (symmetric && weights.length != 2 * observations + 1) {
                throw new DimensionMismatchException(weights.length, 2 * observations + 1);
            }
        }
        this.weights = weights;
    }

    @Override
    public double[] filter(double[] values) {
        if (this.weights == null) {
            return this.filterWithoutWeights(values);
        }
        return this.filterWithWeights(values);
    }

    private double[] filterWithoutWeights(double[] values) {
        int i;
        int index;
        int windowSize;
        int length = values.length;
        double[] result = new double[length];
        if (this.symmetric) {
            windowSize = 2 * this.observations + 1;
            index = this.observations;
        } else {
            windowSize = this.observations;
            index = this.observations - 1;
        }
        double sum = 0.0;
        for (i = 0; i < windowSize && i < length; ++i) {
            sum += values[i];
        }
        System.arraycopy(values, 0, result, 0, index);
        for (i = windowSize - 1; i < length; ++i) {
            if (i != windowSize - 1) {
                sum += values[i];
                sum -= values[i - windowSize];
            }
            result[index] = sum / (double)windowSize;
            ++index;
        }
        if (this.symmetric) {
            System.arraycopy(values, index, result, index, length - index);
        }
        return result;
    }

    private double[] filterWithWeights(double[] values) {
        int index;
        int windowSize;
        int length = values.length;
        double[] result = new double[length];
        if (this.symmetric) {
            windowSize = 2 * this.observations + 1;
            index = this.observations;
        } else {
            windowSize = this.observations;
            index = this.observations - 1;
        }
        System.arraycopy(values, 0, result, 0, index);
        for (int i = 0; i < length - windowSize + 1; ++i) {
            double sum = 0.0;
            for (int j = i; j < i + windowSize; ++j) {
                sum += values[j] * this.weights[j - i];
            }
            result[index] = sum;
            ++index;
        }
        if (this.symmetric) {
            System.arraycopy(values, index, result, index, length - index);
        }
        return result;
    }
}

