/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.distribution;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import ro.hasna.ts.math.distribution.DistributionDivider;

public class NormalDistributionDivider
implements DistributionDivider {
    private static final long serialVersionUID = -909800668897655203L;

    @Override
    public double[] getBreakpoints(int areas) {
        if (areas < 2) {
            throw new NumberIsTooSmallException(areas, (Number)2, true);
        }
        NormalDistribution normalDistribution = new NormalDistribution();
        int len = areas - 1;
        double[] result = new double[len];
        double searchArea = 1.0 / (double)areas;
        for (int i = 0; i < len; ++i) {
            result[i] = normalDistribution.inverseCumulativeProbability(searchArea * (double)(i + 1));
        }
        return result;
    }
}

