/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.stores;

import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.Timelines;
import io.intino.sumus.chronos.timelines.TimelineReader;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;

public abstract class AbstractTimelineStore
implements TimelineStore {
    private TimelineStore.Header header;
    private TimelineStore.SensorModel sensorModel;
    private TimelineStore.TimeModel timeModel;

    protected void init() throws IOException {
        try (SeekableByteChannel channel = this.openChannel();){
            this.header = TimelineReader.readHeader(channel);
            this.sensorModel = TimelineReader.readSensorModel(this.header.sensorModelPosition(), channel);
            this.timeModel = TimelineReader.readTimeModel(this.header.timeModelPosition(), channel);
        }
    }

    @Override
    public Timeline timeline() throws IOException {
        return Timelines.read(this.openChannel());
    }

    @Override
    public TimelineStore.Header header() {
        return this.header;
    }

    @Override
    public TimelineStore.SensorModel sensorModel() {
        return this.sensorModel;
    }

    @Override
    public TimelineStore.TimeModel timeModel() {
        return this.timeModel;
    }

    protected abstract SeekableByteChannel openChannel() throws IOException;
}

