/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.blocks;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.TimelineStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SensorModel
implements TimelineStore.SensorModel {
    static final int HEADER_SIZE = 6;
    static final String MAGNITUDE_SEPARATOR = "\n";
    private final long position;
    private final Magnitude[] magnitudes;
    private final Map<Magnitude, Integer> index;

    public SensorModel(String ... magnitudes) {
        this(-1L, magnitudes);
    }

    public SensorModel(long position, String ... magnitudes) {
        this((Magnitude[])Arrays.stream(magnitudes).map(Magnitude::new).toArray(Magnitude[]::new));
    }

    public SensorModel(Magnitude ... magnitudes) {
        this(-1L, magnitudes);
    }

    public SensorModel(long position, Magnitude ... magnitudes) {
        this.position = position;
        this.magnitudes = magnitudes;
        this.index = new HashMap<Magnitude, Integer>(magnitudes.length);
        this.initIndex(magnitudes);
    }

    public long position() {
        return this.position;
    }

    @Override
    public Magnitude[] magnitudes() {
        return this.magnitudes;
    }

    @Override
    public Magnitude get(int i) {
        return i >= 0 ? this.magnitudes[i] : null;
    }

    @Override
    public Magnitude get(String measurement) {
        return this.get(this.indexOf(new Magnitude(measurement)));
    }

    @Override
    public int indexOf(Magnitude magnitude) {
        return this.index.getOrDefault(magnitude, -1);
    }

    @Override
    public int indexOf(String magnitude) {
        return this.index.getOrDefault(new Magnitude(magnitude), -1);
    }

    @Override
    public int size() {
        return this.magnitudes.length;
    }

    @Override
    public boolean has(String measurement) {
        return this.index.containsKey(new Magnitude(measurement));
    }

    @Override
    public boolean has(Magnitude magnitude) {
        return this.index.containsKey(magnitude);
    }

    private void initIndex(Magnitude[] magnitudes) {
        for (int i = 0; i < magnitudes.length; ++i) {
            this.index.put(magnitudes[i], i);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || Arrays.equals(this.magnitudes, ((TimelineStore.SensorModel)o).magnitudes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.magnitudes);
    }

    public String toString() {
        return Arrays.stream(this.magnitudes).map(Magnitude::toString).collect(Collectors.joining(MAGNITUDE_SEPARATOR));
    }

    public static ByteBuffer serialize(TimelineStore.SensorModel sensorModel) {
        byte[] utf8 = String.join((CharSequence)MAGNITUDE_SEPARATOR, sensorModel.magnitudes()).getBytes(StandardCharsets.UTF_8);
        return SensorModel.serialize(utf8, ByteBuffer.allocate(6 + utf8.length)).clear();
    }

    public static ByteBuffer serialize(byte[] utf8, ByteBuffer buffer) {
        buffer.putShort((short)26209);
        buffer.putInt(utf8.length);
        buffer.put(utf8);
        return buffer;
    }

    public static TimelineStore.SensorModel deserialize(ReadableByteChannel channel, boolean readMark) throws IOException {
        long position;
        long l = position = channel instanceof SeekableByteChannel ? ((SeekableByteChannel)channel).position() : -1L;
        if (!readMark && position > 0L) {
            position -= 2L;
        }
        ByteBuffer headerBuffer = ByteBuffer.allocate(readMark ? 6 : 4);
        channel.read(headerBuffer);
        ByteBuffer utf8 = ByteBuffer.allocate(headerBuffer.getInt(readMark ? 2 : 0));
        channel.read(utf8);
        String[] magnitudes = new String(utf8.array(), StandardCharsets.UTF_8).split(MAGNITUDE_SEPARATOR, -1);
        return new SensorModel(position, magnitudes);
    }
}

