/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines;

import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineReader;
import io.intino.sumus.chronos.timelines.blocks.Data;
import io.intino.sumus.chronos.timelines.blocks.Header;
import io.intino.sumus.chronos.timelines.blocks.SensorModel;
import io.intino.sumus.chronos.timelines.blocks.TimeModel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimelineFixer
implements AutoCloseable {
    private final SeekableByteChannel channel;
    private final TimelineStore.Header header;
    private final List<SensorModel> sensorModels;
    private final Map<Instant, Long> instantPositions;
    private TimelineStore.SensorModel sensorModel;

    public TimelineFixer(File file) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public TimelineFixer(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        this.header = TimelineReader.readHeader(channel, new Header());
        this.sensorModels = new ArrayList<SensorModel>();
        this.instantPositions = this.buildInstantPositionMap();
    }

    public TimelineFixer seek(Instant instant) throws IOException {
        if (!this.instantPositions.containsKey(instant)) {
            throw new IllegalArgumentException("Instant " + instant + " not found");
        }
        this.channel.position(this.instantPositions.get(instant));
        this.sensorModel = this.getCurrentSensorModel();
        return this;
    }

    public double get(String magnitude) throws IOException {
        int index = this.sensorModel.indexOf(magnitude);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        long position = this.channel.position();
        this.channel.position(position + (long)index * 8L);
        this.channel.read(buffer);
        this.channel.position(position);
        return buffer.getDouble(0);
    }

    public TimelineFixer set(String magnitude, double value) throws IOException {
        int index = this.sensorModel.indexOf(magnitude);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(0, value);
        long position = this.channel.position();
        this.channel.position(position + (long)index * 8L);
        this.channel.write(buffer);
        this.channel.position(position);
        return this;
    }

    private TimelineStore.SensorModel getCurrentSensorModel() throws IOException {
        long currentPosition = this.channel.position();
        for (int i = this.sensorModels.size() - 1; i >= 0; --i) {
            SensorModel sensorModel = this.sensorModels.get(i);
            if (sensorModel.position() >= currentPosition) continue;
            return sensorModel;
        }
        return this.sensorModels.get(this.sensorModels.size() - 1);
    }

    private Map<Instant, Long> buildInstantPositionMap() throws IOException {
        this.channel.position(0L);
        LinkedHashMap<Instant, Long> indices = new LinkedHashMap<Instant, Long>(Math.max((int)this.header.recordCount(), 16));
        TimelineReader reader = new TimelineReader(this.channel);
        TimeModel timeModel = null;
        Instant[] instant = new Instant[1];
        while (reader.hasNext()) {
            TimelineStore.Block block = reader.next();
            switch (block.mark()) {
                case 21845: {
                    this.index((Data)block, timeModel, instant, indices);
                    break;
                }
                case 26208: {
                    timeModel = (TimeModel)block;
                    instant[0] = timeModel.instant();
                    break;
                }
                case 26209: {
                    this.sensorModels.add((SensorModel)block);
                }
            }
        }
        return indices;
    }

    private void index(Data block, TimelineStore.TimeModel timeModel, Instant[] instant, Map<Instant, Long> indices) {
        long position = block.position();
        if (position == -1L) {
            throw new IllegalStateException("Unknown data block position in the channel");
        }
        position += 6L;
        for (int i = 0; i < block.numRecords(); ++i) {
            indices.put(instant[0], position + (long)i * (long)block.recordByteSize());
            instant[0] = timeModel.next(instant[0]);
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public String toString() {
        try {
            return "ChronosFixer{pos=" + this.channel.position() + "}";
        }
        catch (IOException e) {
            return this.getClass().getSimpleName();
        }
    }
}

