/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Program;
import io.intino.sumus.chronos.TimeSeries;
import io.intino.sumus.chronos.TimelineImpl;
import io.intino.sumus.chronos.TimelineStore;
import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public interface Timeline
extends Iterable<Point> {
    public static final Timeline Null = new TimelineImpl(new Instant[0], new LinkedHashMap<Magnitude, double[]>(0));

    public static Timeline empty() {
        return new TimelineImpl(new Instant[0], new LinkedHashMap<Magnitude, double[]>());
    }

    public static Builder builder(int size) {
        return new TimelineImpl.Builder(size);
    }

    public static Builder builder(Instant[] instants) {
        return new TimelineImpl.Builder(instants);
    }

    public int magnitudesCount();

    public int instantsCount();

    default public int size() {
        return this.instantsCount();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<Magnitude> magnitudes();

    public Instant[] instants();

    public Map<Magnitude, double[]> measurements();

    public Instant instant(int var1);

    public boolean has(String var1);

    public boolean has(Magnitude var1);

    public TimeSeries get(String var1);

    public TimeSeries get(Magnitude var1);

    public boolean isBefore(Timeline var1);

    public boolean isAfter(Timeline var1);

    public Point first();

    public Point last();

    public Point at(Instant var1);

    public Timeline head(int var1);

    public Timeline tail(int var1);

    public Timeline from(Instant var1);

    public Timeline from(Instant var1, int var2);

    public Timeline from(Instant var1, Instant var2);

    public Timeline to(Instant var1);

    public Stream<Point> stream();

    @Override
    public Iterator<Point> iterator();

    public Timeline add(Timeline var1);

    public Timeline add(String var1, TimeSeries var2);

    public Timeline add(Magnitude var1, TimeSeries var2);

    public Timeline add(String var1, Function<Timeline, TimeSeries> var2);

    public Timeline add(Magnitude var1, Function<Timeline, TimeSeries> var2);

    public Timeline concat(Timeline var1);

    public Timeline compose(Function<Magnitude, Magnitude> var1);

    public Timeline resampleBy(Period var1);

    public Timeline resampleBy(Period var1, int var2);

    public Timeline execute(Program var1);

    public Timeline interpolate();

    public static interface Builder {
        public Timeline build();

        public Magnitude get(String var1);

        public Builder put(Timeline var1);

        public Builder put(Magnitude var1, TimeSeries var2);

        public Builder put(Magnitude var1, double[] var2);

        public Builder put(Map<Magnitude, double[]> var1);

        public Builder set(Instant var1);

        public boolean isComplete();

        public void set(TimelineStore.SensorModel var1, TimelineStore.Data var2);

        public void set(Magnitude[] var1, Instant var2, double[] var3);

        public Builder set(String var1, double var2);

        public Builder set(Magnitude var1, double var2);

        public void register(Magnitude var1);

        public TimeSeries series(Magnitude var1);
    }

    public static interface Point {
        public Instant instant();

        public Set<Magnitude> magnitudes();

        public boolean has(String var1);

        public boolean has(Magnitude var1);

        public double value(String var1);

        public double value(Magnitude var1);

        public double[] values();

        public Stream<Point> forward();

        public Stream<Point> backward();

        public Point next();

        public Point prev();

        public Point step(int var1);
    }
}

