/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class PlaceAssertion
extends MessageEvent
implements Serializable {
    public PlaceAssertion(String ss, String id) {
        this(new MessageEvent("PlaceAssertion", ss).toMessage(), id);
    }

    public PlaceAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public PlaceAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private PlaceAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public PlaceAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public PlaceAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public PlaceAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static PlaceAssertion fromString(String event) {
        return new PlaceAssertion(new MessageReader(event).next());
    }

    public String label() {
        return !this.message.contains("label") ? null : this.message.get("label").asString();
    }

    public String area() {
        return !this.message.contains("area") ? null : this.message.get("area").asString();
    }

    public String coordinates() {
        return !this.message.contains("coordinates") ? null : this.message.get("coordinates").asString();
    }

    public Integer timeOffset() {
        return this.message.get("timeOffset").asInteger();
    }

    public String region() {
        return !this.message.contains("region") ? null : this.message.get("region").asString();
    }

    public String city() {
        return !this.message.contains("city") ? null : this.message.get("city").asString();
    }

    public String address() {
        return !this.message.contains("address") ? null : this.message.get("address").asString();
    }

    public String postalCode() {
        return !this.message.contains("postalCode") ? null : this.message.get("postalCode").asString();
    }

    public Dst dst() {
        return !this.message.contains("dst") ? null : Dst.valueOf(this.message.get("dst").asString());
    }

    public PlaceAssertion label(String label) {
        if (label == null) {
            this.message.remove("label");
        } else {
            this.message.set("label", label);
        }
        return this;
    }

    public PlaceAssertion area(String area) {
        if (area == null) {
            this.message.remove("area");
        } else {
            this.message.set("area", area);
        }
        return this;
    }

    public PlaceAssertion coordinates(String coordinates) {
        if (coordinates == null) {
            this.message.remove("coordinates");
        } else {
            this.message.set("coordinates", coordinates);
        }
        return this;
    }

    public PlaceAssertion timeOffset(Integer timeOffset) {
        this.message.set("timeOffset", timeOffset);
        return this;
    }

    public PlaceAssertion region(String region) {
        if (region == null) {
            this.message.remove("region");
        } else {
            this.message.set("region", region);
        }
        return this;
    }

    public PlaceAssertion city(String city) {
        if (city == null) {
            this.message.remove("city");
        } else {
            this.message.set("city", city);
        }
        return this;
    }

    public PlaceAssertion address(String address) {
        if (address == null) {
            this.message.remove("address");
        } else {
            this.message.set("address", address);
        }
        return this;
    }

    public PlaceAssertion postalCode(String postalCode) {
        if (postalCode == null) {
            this.message.remove("postalCode");
        } else {
            this.message.set("postalCode", postalCode);
        }
        return this;
    }

    public PlaceAssertion dst(Dst dst) {
        if (dst == null) {
            this.message.remove("dst");
        } else {
            this.message.set("dst", dst.name());
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Dst {
        enabled,
        disabled;

    }
}

