/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ObservableAssertion
extends MessageEvent
implements Serializable {
    private List<Operation> operationList = null;

    public ObservableAssertion(String ss, String id) {
        this(new MessageEvent("ObservableAssertion", ss).toMessage(), id);
    }

    public ObservableAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ObservableAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ObservableAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ObservableAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ObservableAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public ObservableAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static ObservableAssertion fromString(String event) {
        return new ObservableAssertion(new MessageReader(event).next());
    }

    public String label() {
        return !this.message.contains("label") ? null : this.message.get("label").asString();
    }

    public String place() {
        return !this.message.contains("place") ? null : this.message.get("place").asString();
    }

    public String team() {
        return !this.message.contains("team") ? null : this.message.get("team").asString();
    }

    public String model() {
        return !this.message.contains("model") ? null : this.message.get("model").asString();
    }

    public String container() {
        return !this.message.contains("container") ? null : this.message.get("container").asString();
    }

    public String observer() {
        return !this.message.contains("observer") ? null : this.message.get("observer").asString();
    }

    public String responsible() {
        return !this.message.contains("responsible") ? null : this.message.get("responsible").asString();
    }

    public List<String> tags() {
        String[] array = this.message.get("tags").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ObservableAssertion.this.message.append("tags", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ObservableAssertion.this.message.remove("tags", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ObservableAssertion.this.message.remove("tags");
            }
        };
    }

    public List<Operation> operationList() {
        if (this.operationList != null) {
            return this.operationList;
        }
        this.operationList = new ArrayList<Operation>((Collection)this.message.components("Operation").stream().map(c -> new Operation((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Operation element) {
                super.add(element);
                ObservableAssertion.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Operation element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Operation)) {
                    return false;
                }
                super.remove(o);
                ObservableAssertion.this.message.remove(((Operation)o).toMessage());
                return true;
            }

            @Override
            public Operation remove(int index) {
                Operation type = (Operation)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Operation> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Operation)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Operation> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Operation> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.operationList;
    }

    public ObservableAssertion label(String label) {
        if (label == null) {
            this.message.remove("label");
        } else {
            this.message.set("label", label);
        }
        return this;
    }

    public ObservableAssertion place(String place) {
        if (place == null) {
            this.message.remove("place");
        } else {
            this.message.set("place", place);
        }
        return this;
    }

    public ObservableAssertion team(String team) {
        if (team == null) {
            this.message.remove("team");
        } else {
            this.message.set("team", team);
        }
        return this;
    }

    public ObservableAssertion model(String model) {
        if (model == null) {
            this.message.remove("model");
        } else {
            this.message.set("model", model);
        }
        return this;
    }

    public ObservableAssertion container(String container) {
        if (container == null) {
            this.message.remove("container");
        } else {
            this.message.set("container", container);
        }
        return this;
    }

    public ObservableAssertion observer(String observer) {
        if (observer == null) {
            this.message.remove("observer");
        } else {
            this.message.set("observer", observer);
        }
        return this;
    }

    public ObservableAssertion responsible(String responsible) {
        if (responsible == null) {
            this.message.remove("responsible");
        } else {
            this.message.set("responsible", responsible);
        }
        return this;
    }

    public ObservableAssertion tags(List<String> tags) {
        this.message.set("tags", tags);
        return this;
    }

    public ObservableAssertion operationList(List<Operation> operation) {
        new ArrayList<Operation>(this.operationList()).forEach((Consumer<Operation>)((Consumer<Object>)v -> this.operationList.remove(v)));
        this.operationList.addAll(operation);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }

    public static class Operation
    implements Serializable {
        private List<Procedure> procedureList = null;
        protected Message message;

        public Operation() {
            this.message = new Message("Operation");
        }

        public Operation(Message message) {
            this.message = message;
        }

        public String activity() {
            return !this.message.contains("activity") ? null : this.message.get("activity").asString();
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public List<Procedure> procedureList() {
            if (this.procedureList != null) {
                return this.procedureList;
            }
            this.procedureList = new ArrayList<Procedure>((Collection)this.message.components("Procedure").stream().map(c -> new Procedure((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(Procedure element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, Procedure element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Procedure)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((Procedure)o).toMessage());
                    return true;
                }

                @Override
                public Procedure remove(int index) {
                    Procedure type = (Procedure)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super Procedure> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Procedure)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends Procedure> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Procedure> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.procedureList;
        }

        public Operation activity(String activity) {
            if (activity == null) {
                this.message.remove("activity");
            } else {
                this.message.set("activity", activity);
            }
            return this;
        }

        public Operation name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Operation procedureList(List<Procedure> procedure) {
            new ArrayList<Procedure>(this.procedureList()).forEach((Consumer<Procedure>)((Consumer<Object>)v -> this.procedureList.remove(v)));
            this.procedureList.addAll(procedure);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Procedure
        implements Serializable {
            private List<Parameter> parameterList = null;
            protected Message message;

            public Procedure() {
                this.message = new Message("Procedure");
            }

            public Procedure(Message message) {
                this.message = message;
            }

            public String name() {
                return !this.message.contains("name") ? null : this.message.get("name").asString();
            }

            public String returnType() {
                return !this.message.contains("returnType") ? null : this.message.get("returnType").asString();
            }

            public String description() {
                return !this.message.contains("description") ? null : this.message.get("description").asString();
            }

            public List<Parameter> parameterList() {
                if (this.parameterList != null) {
                    return this.parameterList;
                }
                this.parameterList = new ArrayList<Parameter>((Collection)this.message.components("Parameter").stream().map(c -> new Parameter((Message)c)).collect(Collectors.toList())){

                    @Override
                    public boolean add(Parameter element) {
                        super.add(element);
                        message.add(element.toMessage());
                        return true;
                    }

                    @Override
                    public void add(int index, Parameter element) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean remove(Object o) {
                        if (!(o instanceof Parameter)) {
                            return false;
                        }
                        super.remove(o);
                        message.remove(((Parameter)o).toMessage());
                        return true;
                    }

                    @Override
                    public Parameter remove(int index) {
                        Parameter type = (Parameter)this.get(index);
                        this.remove(type);
                        return type;
                    }

                    @Override
                    public boolean removeIf(Predicate<? super Parameter> filter) {
                        return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Parameter)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        c.forEach(this::remove);
                        return true;
                    }

                    @Override
                    public boolean addAll(Collection<? extends Parameter> c) {
                        c.forEach(this::add);
                        return true;
                    }

                    @Override
                    public boolean addAll(int index, Collection<? extends Parameter> c) {
                        throw new UnsupportedOperationException();
                    }
                };
                return this.parameterList;
            }

            public Procedure name(String name) {
                if (name == null) {
                    this.message.remove("name");
                } else {
                    this.message.set("name", name);
                }
                return this;
            }

            public Procedure returnType(String returnType) {
                if (returnType == null) {
                    this.message.remove("returnType");
                } else {
                    this.message.set("returnType", returnType);
                }
                return this;
            }

            public Procedure description(String description) {
                if (description == null) {
                    this.message.remove("description");
                } else {
                    this.message.set("description", description);
                }
                return this;
            }

            public Procedure parameterList(List<Parameter> parameter) {
                new ArrayList<Parameter>(this.parameterList()).forEach((Consumer<Parameter>)((Consumer<Object>)v -> this.parameterList.remove(v)));
                this.parameterList.addAll(parameter);
                return this;
            }

            public Message toMessage() {
                return this.message;
            }

            public static class Parameter
            implements Serializable {
                protected Message message;

                public Parameter() {
                    this.message = new Message("Parameter");
                }

                public Parameter(Message message) {
                    this.message = message;
                }

                public String type() {
                    return !this.message.contains("type") ? null : this.message.get("type").asString();
                }

                public String name() {
                    return !this.message.contains("name") ? null : this.message.get("name").asString();
                }

                public Parameter type(String type) {
                    if (type == null) {
                        this.message.remove("type");
                    } else {
                        this.message.set("type", type);
                    }
                    return this;
                }

                public Parameter name(String name) {
                    if (name == null) {
                        this.message.remove("name");
                    } else {
                        this.message.set("name", name);
                    }
                    return this;
                }

                public Message toMessage() {
                    return this.message;
                }
            }
        }
    }
}

