/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class HardwareAssertion
extends ObservableAssertion
implements Serializable {
    public HardwareAssertion(String ss, String id) {
        this(new MessageEvent("HardwareAssertion", ss).toMessage(), id);
    }

    public HardwareAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public HardwareAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private HardwareAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public HardwareAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public HardwareAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public HardwareAssertion enabled(boolean enabled) {
        this.message.set("enabled", enabled);
        return this;
    }

    public static HardwareAssertion fromString(String event) {
        return new HardwareAssertion(new MessageReader(event).next());
    }

    public String sn() {
        return !this.message.contains("sn") ? null : this.message.get("sn").asString();
    }

    public List<String> ip() {
        String[] array = this.message.get("ip").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                HardwareAssertion.this.message.append("ip", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                HardwareAssertion.this.message.remove("ip", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                HardwareAssertion.this.message.remove("ip");
            }
        };
    }

    public String publicIp() {
        return !this.message.contains("publicIp") ? null : this.message.get("publicIp").asString();
    }

    public HardwareAssertion sn(String sn) {
        if (sn == null) {
            this.message.remove("sn");
        } else {
            this.message.set("sn", sn);
        }
        return this;
    }

    public HardwareAssertion ip(List<String> ip) {
        this.message.set("ip", ip);
        return this;
    }

    public HardwareAssertion publicIp(String publicIp) {
        if (publicIp == null) {
            this.message.remove("publicIp");
        } else {
            this.message.set("publicIp", publicIp);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

