/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Wireless
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"connection.failed.association;" + String.join((CharSequence)";", "format=%d", "operator=sum", "tail=UP", "distribution=Poisson"), "connection.failed.authentication;" + String.join((CharSequence)";", "format=%d", "operator=sum", "tail=UP", "distribution=Poisson"), "connection.failed.dhcp;" + String.join((CharSequence)";", "format=%d", "operator=sum", "tail=UP", "distribution=Poisson"), "connection.failed.dns;" + String.join((CharSequence)";", "format=%d", "operator=sum", "tail=UP", "distribution=Poisson"), "connection.sucess;" + String.join((CharSequence)";", "format=%d", "operator=sum", "tail=DOWN", "distribution=Normal")};

    public Wireless(String ss) {
        super("Wireless", ss, Instant.now(), declaredMagnitudes, new double[5]);
    }

    public Wireless(String ss, String sensor) {
        super("Wireless", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[5]);
    }

    public Wireless(String ss, String sensor, Instant ts) {
        super("Wireless", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[5]);
    }

    public Wireless(MeasurementEvent event) {
        super("Wireless", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public Wireless(Message message) {
        super("Wireless", message.get("ss").asString(), message.get("ts").asInstant(), message.get("magnitudes").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double assoc() {
        return this.values[0];
    }

    public double auth() {
        return this.values[1];
    }

    public double dhcp() {
        return this.values[2];
    }

    public double dns() {
        return this.values[3];
    }

    public double success() {
        return this.values[4];
    }

    public Wireless assoc(double value) {
        this.values[0] = value;
        return this;
    }

    public Wireless auth(double value) {
        this.values[1] = value;
        return this;
    }

    public Wireless dhcp(double value) {
        this.values[2] = value;
        return this;
    }

    public Wireless dns(double value) {
        this.values[3] = value;
        return this;
    }

    public Wireless success(double value) {
        this.values[4] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

