/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Application
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"usage.RAM;" + String.join((CharSequence)";", "unit=MB", "format=%,.2f", "operator=avg", "tail=UP", "distribution=Normal"), "usage.CPU;" + String.join((CharSequence)";", "unit=%", "format=%,.2f", "operator=avg", "max=100", "tail=UP"), "usage.threads;" + String.join((CharSequence)";", "format=%d", "operator=avg", "tail=UP", "distribution=Normal"), "usage.files;" + String.join((CharSequence)";", "format=%d", "operator=avg", "tail=UP", "distribution=Normal"), "data.read;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=avg", "tail=UP"), "data.written;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=avg", "tail=UP")};

    public Application(String ss) {
        super("Application", ss, Instant.now(), declaredMagnitudes, new double[6]);
    }

    public Application(String ss, String sensor) {
        super("Application", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[6]);
    }

    public Application(String ss, String sensor, Instant ts) {
        super("Application", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[6]);
    }

    public Application(MeasurementEvent event) {
        super("Application", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public Application(Message message) {
        super("Application", message.get("ss").asString(), message.get("ts").asInstant(), message.get("magnitudes").as(String[].class), Arrays.stream(message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double usageRAM() {
        return this.values[0];
    }

    public double usageCPU() {
        return this.values[1];
    }

    public double usageThreads() {
        return this.values[2];
    }

    public double usageFiles() {
        return this.values[3];
    }

    public double dataRead() {
        return this.values[4];
    }

    public double dataWritten() {
        return this.values[5];
    }

    public Application usageRAM(double value) {
        this.values[0] = value;
        return this;
    }

    public Application usageCPU(double value) {
        this.values[1] = value;
        return this;
    }

    public Application usageThreads(double value) {
        this.values[2] = value;
        return this;
    }

    public Application usageFiles(double value) {
        this.values[3] = value;
        return this;
    }

    public Application dataRead(double value) {
        this.values[4] = value;
        return this;
    }

    public Application dataWritten(double value) {
        this.values[5] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", m));
        return new MessageEvent(message);
    }
}

