/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.mounters.ModelMounter;
import io.intino.ness.master.Datamart;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModelMounter
implements MasterMounter {
    private final MasterDatamart.Entities entities;
    private final List<Datamart.EntityListener> listeners;
    private boolean useListeners = true;

    public ModelMounter(MasterDatamart.Entities entities, List<Datamart.EntityListener> listeners) {
        this.entities = entities;
        this.listeners = listeners;
    }

    @Override
    public ModelMounter useListeners(boolean useListeners) {
        this.useListeners = useListeners;
        return this;
    }

    @Override
    public void mount(Event event) {
        Message message = ((MessageEvent)event).toMessage();
        String id = message.get("id").asString();
        MasterMounter.Operation[] operation = new MasterMounter.Operation[]{MasterMounter.Operation.Update};
        MasterEntity entity = this.findOrCreateEntity(id, operation);
        this.updateAttributes(message, operation, entity);
        if (operation[0] != MasterMounter.Operation.Skip && this.useListeners) {
            this.notifyListeners(operation[0], entity);
        }
    }

    private void updateAttributes(Message message, MasterMounter.Operation[] operation, MasterEntity owner) {
        for (String attr : message.attributes()) {
            this.update(owner, attr, this.parse(attr, message));
            if (!attr.equals("enabled")) continue;
            if (message.get("enabled").asBoolean().booleanValue()) {
                this.entities.enable(owner.id());
                continue;
            }
            this.entities.disable(owner.id());
        }
        Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));
        if (components.containsKey("Profile")) {
            this.update(owner, "profile", (Object)new Model.ProfileStructFactory(this).create(components.get("Profile").get(0)));
        }
    }

    private MasterEntity findOrCreateEntity(String id, MasterMounter.Operation[] operation) {
        Object entity = this.entities.get(Model.definition, id);
        if (entity == null) {
            entity = this.entities.getDisabled(Model.definition, id);
        }
        if (entity == null) {
            entity = new Model(id, this.entities.datamart());
            this.entities.add((MasterEntity)entity);
            operation[0] = MasterMounter.Operation.Create;
        }
        return entity;
    }

    private void notifyListeners(MasterMounter.Operation operation, MasterEntity entity) {
        for (Datamart.EntityListener listener : this.listeners) {
            switch (operation) {
                case Create: {
                    new Thread(() -> listener.onCreate(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Update: {
                    new Thread(() -> listener.onUpdate(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start();
                    break;
                }
                case Remove: {
                    new Thread(() -> listener.onRemove(entity), "MasterListener-ModelMounter-" + System.currentTimeMillis()).start();
                }
            }
        }
    }

    private Object parse(String attribute, Message message) {
        if (message.get(attribute).isNull()) {
            return null;
        }
        switch (attribute) {
            case "type": {
                return this.parseType(message);
            }
            case "target": {
                return this.parseTarget(message);
            }
        }
        return message.get(attribute).asString();
    }

    private String parseType(Message m) {
        return m.get("type").as(String.class);
    }

    private String parseTarget(Message m) {
        return m.get("target").as(String.class);
    }
}

