/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.container.box.service.requests.ContainerRequest;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;

public class UninstallActivityRequest
extends ContainerRequest {
    public static final String ID = "uninstallActivity";
    private final ContainerBox box;
    private final Activity.Context context;

    public UninstallActivityRequest(ContainerBox box, Activity.Context context) {
        this.box = box;
        this.context = context;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            String activityId = this.activity(request);
            if (activityId == null) {
                return new RequestAttendant.RequestResult(false, "Activity not found");
            }
            if (this.box.activities().enabledActivities().contains(activityId)) {
                Logger.warn("The activity " + activityId + " could no be uninstalled. It was enabled. Please disable first.");
                return new RequestAttendant.RequestResult(false, "The activity " + activityId + " could no be uninstalled. It was enabled. Please disable first.");
            }
            Activity.Result result = this.box.activities().uninstallActivity(activityId);
            new Thread(() -> new ObserverAssertionAction(this.box, this.context).execute()).start();
            return new RequestAttendant.RequestResult(result.success(), result.remarks());
        }
        catch (Throwable e) {
            Logger.error(e);
            return new RequestAttendant.RequestResult(false, e.getMessage());
        }
    }

    @Override
    public boolean isAvailable(Message message) {
        return true;
    }
}

