/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.service;

import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.service.requests.ActivitiesRequest;
import io.intino.consul.container.box.service.requests.DisableActivityRequest;
import io.intino.consul.container.box.service.requests.EnableActivityRequest;
import io.intino.consul.container.box.service.requests.ExploreFileSystemRequest;
import io.intino.consul.container.box.service.requests.FactoryResetRequest;
import io.intino.consul.container.box.service.requests.GetActivityConfigurationRequest;
import io.intino.consul.container.box.service.requests.InfoRequest;
import io.intino.consul.container.box.service.requests.InstallActivityRequest;
import io.intino.consul.container.box.service.requests.RestartConsulRequest;
import io.intino.consul.container.box.service.requests.RunScriptRequest;
import io.intino.consul.container.box.service.requests.UninstallActivityRequest;
import io.intino.consul.container.box.service.requests.UpdateActivityConfigurationRequest;
import io.intino.consul.container.box.service.requests.UpgradeActivityRequest;
import io.intino.consul.container.box.service.requests.UpgradeRequest;
import io.intino.consul.container.box.service.requests.UploadFileRequest;
import io.intino.consul.terminal.ConsulService;

public class ServiceConfigurator {
    private static final String SEP = "#";
    private static final String PREFIX = "container";
    private final ContainerBox box;

    public ServiceConfigurator(ContainerBox box) {
        this.box = box;
    }

    public void configure(ConsulService service) {
        ContainerStore store = (ContainerStore)this.box.store();
        service.register("container#activities", new ActivitiesRequest(this.box));
        service.register("container#info", new InfoRequest(this.box));
        service.register("container#factoryReset", new FactoryResetRequest(this.box, this.box.context(), store));
        service.register("container#restart", new RestartConsulRequest());
        service.register("container#installActivity", new InstallActivityRequest(this.box, this.box.context(), store));
        service.register("container#upgradeActivity", new UpgradeActivityRequest(this.box, this.box.context(), store));
        service.register("container#enableActivity", new EnableActivityRequest(this.box, this.box.context()));
        service.register("container#disableActivity", new DisableActivityRequest(this.box, this.box.context(), store));
        service.register("container#uninstallActivity", new UninstallActivityRequest(this.box, this.box.context()));
        service.register("container#activityConfiguration", new GetActivityConfigurationRequest(this.box, this.box.context(), store));
        service.register("container#updateActivityConfiguration", new UpdateActivityConfigurationRequest(this.box, this.box.context(), store));
        service.register("container#upgrade", new UpgradeRequest(this.box, this.box.configuration()));
        service.register("container#uploadFile", new UploadFileRequest());
        service.register("container#runScript", new RunScriptRequest(this.box, this.box.context(), store));
        service.register("container#exploreFileSystem", new ExploreFileSystemRequest());
    }
}

