/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.schemas;

import io.intino.consul.container.box.schemas.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Manifest
implements Serializable {
    private String name;
    private String description;
    private Boolean needInstallToConfig = false;
    private List<String> dependantActivities = new ArrayList<String>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Container container;
    private Service service;

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean needInstallToConfig() {
        return this.needInstallToConfig;
    }

    public List<String> dependantActivities() {
        return this.dependantActivities;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Container container() {
        return this.container;
    }

    public Service service() {
        return this.service;
    }

    public Manifest name(String name) {
        this.name = name;
        return this;
    }

    public Manifest description(String description) {
        this.description = description;
        return this;
    }

    public Manifest needInstallToConfig(Boolean needInstallToConfig) {
        this.needInstallToConfig = needInstallToConfig;
        return this;
    }

    public Manifest dependantActivities(List<String> dependantActivities) {
        this.dependantActivities = dependantActivities;
        return this;
    }

    public Manifest parameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Manifest container(Container container) {
        this.container = container;
        return this;
    }

    public Manifest service(Service service) {
        this.service = service;
        return this;
    }

    public static class Container
    implements Serializable {
        private String minVersion;
        private String maxVersion;

        public String minVersion() {
            return this.minVersion;
        }

        public String maxVersion() {
            return this.maxVersion;
        }

        public Container minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public Container maxVersion(String maxVersion) {
            this.maxVersion = maxVersion;
            return this;
        }
    }

    public static class Service
    implements Serializable {
        private List<Endpoint> endpoint = new ArrayList<Endpoint>();

        public List<Endpoint> endpointList() {
            return this.endpoint;
        }

        public List<Endpoint> endpointList(Predicate<Endpoint> predicate) {
            return this.endpoint.stream().filter(predicate).collect(Collectors.toList());
        }

        public Endpoint endpoint(Predicate<Endpoint> predicate) {
            return this.endpoint.stream().filter(predicate).findFirst().orElse(null);
        }

        public Service endpointList(List<Endpoint> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public static class Endpoint
        implements Serializable {
            private String name;
            private String label;
            private String icon;
            private String description;
            private List<Parameter> parameters = new ArrayList<Parameter>();
            private Response response;

            public String name() {
                return this.name;
            }

            public String label() {
                return this.label;
            }

            public String icon() {
                return this.icon;
            }

            public String description() {
                return this.description;
            }

            public List<Parameter> parameters() {
                return this.parameters;
            }

            public Response response() {
                return this.response;
            }

            public Endpoint name(String name) {
                this.name = name;
                return this;
            }

            public Endpoint label(String label) {
                this.label = label;
                return this;
            }

            public Endpoint icon(String icon) {
                this.icon = icon;
                return this;
            }

            public Endpoint description(String description) {
                this.description = description;
                return this;
            }

            public Endpoint parameters(List<Parameter> parameters) {
                this.parameters = parameters;
                return this;
            }

            public Endpoint response(Response response) {
                this.response = response;
                return this;
            }

            public static class Response
            implements Serializable {
                private String type;
                private String description;

                public String type() {
                    return this.type;
                }

                public String description() {
                    return this.description;
                }

                public Response type(String type) {
                    this.type = type;
                    return this;
                }

                public Response description(String description) {
                    this.description = description;
                    return this;
                }
            }
        }
    }
}

