/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.activity;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.schemas.Manifest;
import io.intino.consul.container.box.schemas.Parameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestReader {
    public static Manifest of(String serialized) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(serialized.getBytes()));
            document.getDocumentElement().normalize();
            Element activity = (Element)document.getFirstChild();
            return new Manifest().name(ManifestReader.childOf(activity, "name")).description(ManifestReader.childOf(activity, "description")).container(ManifestReader.containerFrom(ManifestReader.asList(activity.getElementsByTagName("container")))).needInstallToConfig(Boolean.getBoolean(ManifestReader.childOf(activity, "installToConfig"))).dependantActivities(ManifestReader.content(ManifestReader.asList(activity.getElementsByTagName("dependantActivity")))).parameters(ManifestReader.parameters(ManifestReader.asList(activity.getElementsByTagName("parameters")))).service(ManifestReader.service(ManifestReader.asList(activity.getElementsByTagName("service"))));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logger.error(e);
            return null;
        }
    }

    private static Manifest.Container containerFrom(List<Node> containerList) {
        if (containerList.isEmpty()) {
            return null;
        }
        Element container = (Element)containerList.get(0);
        String minVersion = ManifestReader.childOf(container, "minVersion");
        String maxVersion = ManifestReader.childOf(container, "maxVersion");
        return new Manifest.Container().minVersion(minVersion).maxVersion(maxVersion);
    }

    private static List<String> content(List<Node> dependantActivities) {
        return dependantActivities.stream().map(Node::getTextContent).toList();
    }

    private static String childOf(Element activity, String child) {
        return ManifestReader.asList(activity.getElementsByTagName(child)).stream().map(node -> node.getTextContent().trim()).findFirst().orElse(null);
    }

    private static Manifest.Service service(List<Node> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        Element element = (Element)nodes.get(0);
        return new Manifest.Service().endpointList(ManifestReader.asList(element.getElementsByTagName("endpoint")).stream().map(e -> ManifestReader.endPoint((Element)e)).toList());
    }

    private static Manifest.Service.Endpoint endPoint(Element e) {
        return new Manifest.Service.Endpoint().name(ManifestReader.childOf(e, "name")).label(ManifestReader.childOf(e, "label")).icon(ManifestReader.childOf(e, "icon")).description(ManifestReader.childOf(e, "description")).parameters(ManifestReader.parameters(ManifestReader.asList(e.getElementsByTagName("parameters")))).response(ManifestReader.response(ManifestReader.asList(e.getElementsByTagName("response"))));
    }

    private static Manifest.Service.Endpoint.Response response(List<Node> children) {
        Node response = ManifestReader.findNodeByName(children, "response").findFirst().orElse(null);
        if (response == null) {
            return null;
        }
        Map<String, String> attributes = ManifestReader.asMap(response.getAttributes());
        return new Manifest.Service.Endpoint.Response().type(attributes.get("type")).description(attributes.get("description"));
    }

    private static List<Parameter> parameters(List<Node> parameters) {
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        return ManifestReader.asList(((Element)parameters.get(0)).getElementsByTagName("parameter")).stream().map(p -> {
            Map<String, String> attrs = ManifestReader.asMap(p.getAttributes());
            List<String> tsvColumns = attrs.containsKey("columns") ? Arrays.stream(attrs.get("columns").split(",")).toList() : List.of();
            return new Parameter().name(p.getTextContent().trim()).description(attrs.get("description")).isRequired("true".equals(attrs.get("required"))).type(Parameter.Type.valueOf(attrs.get("type").toLowerCase())).tsvColumns(tsvColumns).tsvEditableColumns(attrs.containsKey("editable") ? Arrays.stream(attrs.get("editable").split(",")).toList() : tsvColumns);
        }).toList();
    }

    private static Map<String, String> asMap(NamedNodeMap attributes) {
        return IntStream.range(0, attributes.getLength()).mapToObj(i -> (Attr)attributes.item(i)).collect(Collectors.toMap(Attr::getName, Attr::getValue));
    }

    private static Stream<Node> findNodeByName(List<Node> nodes, String name) {
        return nodes.stream().filter(n -> n.getNodeName().equalsIgnoreCase(name));
    }

    private static List<Node> asList(NodeList childNodes) {
        return IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).toList();
    }
}

