/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box.actions;

import io.intino.alexandria.message.Message;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import io.intino.cosmos.datahub.messages.universe.ObserverAssertion;
import java.util.ArrayList;
import java.util.List;

public class ObserverAssertionAction {
    private final ContainerBox box;
    private final Activity.Context context;

    public ObserverAssertionAction(ContainerBox box, Activity.Context context) {
        this.box = box;
        this.context = context;
    }

    public void execute() {
        ObserverAssertion newInfo = this.observerAssertion();
        if (!this.hasChanges(newInfo)) {
            return;
        }
        if (this.context.terminal() != null) {
            this.context.terminal().publish(newInfo);
        }
        this.box.store().put("root#consulInfo", this.withOutTs(newInfo.toMessage()));
    }

    private ObserverAssertion observerAssertion() {
        return (ObserverAssertion)new ObserverAssertion(this.context.observer(), this.context.observer()).version(Utils.currentVersion()).installedActivities(new ArrayList<String>(this.box.activities().activities().keySet())).enabledActivities(this.box.activities().enabledActivities()).model("application.observer").operationList(List.of(new ObservableAssertion.Operation().name("restartService").activity(null))).container(this.context.hostName());
    }

    private boolean hasChanges(ObserverAssertion newInfo) {
        String last = this.box.store().get("root#consulInfo", String.class);
        return last == null || !this.withOutTs(newInfo.toMessage()).equals(last);
    }

    private String withOutTs(Message message) {
        return message.toString().replaceFirst("\nts:.*\n", "\n");
    }
}

