/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.container.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.jms.ConnectionConfig;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.AbstractBox;
import io.intino.consul.container.box.ContainerConfiguration;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.container.box.activity.ActivityManager;
import io.intino.consul.container.box.os.local.LocalSystem;
import io.intino.consul.container.box.os.remote.RemoteSystem;
import io.intino.consul.container.box.service.ServiceConfigurator;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import io.intino.consul.terminal.Terminal;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;

public class ContainerBox
extends AbstractBox {
    private final ContainerStore store;
    private final Terminal terminal;
    private final ActivityManager manager;
    private final Activity.Context context;
    private final String hostName;

    public ContainerBox(ContainerConfiguration configuration) throws Exception {
        super(configuration);
        io.intino.alexandria.logger4j.Logger.setLevel(Level.ERROR);
        Activity.System system = this.system();
        this.hostName = system.name();
        this.terminal = this.initTerminal(this.hostName);
        this.store = new ContainerStore(configuration.store() == null ? new File(configuration.home(), ".consul") : new File(configuration.store()));
        this.context = new Activity.Context(this.terminal, system, this.hostName, this.observer(), this.unit(), configuration.args());
        this.manager = new ActivityManager(configuration, this.context, this.store, system);
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    public ActivityManager activities() {
        return this.manager;
    }

    @Override
    public void beforeStart() {
    }

    @Override
    public void afterStart() {
        this.terminal.start();
        new ServiceConfigurator(this).configure(this.terminal.service());
        this.manager.loadActivitiesFromStore();
        new ObserverAssertionAction(this, this.context).execute();
        Logger.info("Started Consul v. " + Utils.currentVersion() + " in server: " + this.hostName);
    }

    public Activity.Context context() {
        return this.context;
    }

    public String observer() {
        return this.unit() + "consul-" + this.hostName;
    }

    private String unit() {
        return this.configuration.unit() == null ? "" : this.configuration.unit();
    }

    private Activity.System system() throws Exception {
        return this.configuration.remoteServer() != null ? new RemoteSystem(this.configuration.privateKey(), this.configuration.remoteServer(), this.configuration.remotePort(), this.configuration().remoteUser()) : new LocalSystem(this.configuration.ispProviderToken());
    }

    @Override
    public void beforeStop() {
        this.manager.stopActivities();
    }

    @Override
    public void afterStop() {
        this.terminal.stop();
        this.save();
        Logger.info("Shutting down Consul");
    }

    private Terminal initTerminal(String hostName) {
        return new Terminal(this.observer(), new ConnectionConfig(this.configuration.datahubUrl(), this.configuration.datahubUser(), this.configuration.datahubPassword(), hostName, this.configuration.keyStoreFile(), this.configuration.trustStoreFile(), this.configuration.keyStorePassword(), this.configuration.trustStorePassword(), 1L, TimeUnit.MINUTES));
    }

    public Activity.Store store() {
        return this.store;
    }

    public void save() {
        this.manager.saveConfigurations();
        this.store.save();
    }
}

