/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zit;

import io.intino.alexandria.iteratorstream.ResourceIteratorStream;
import io.intino.alexandria.zit.ItlReader;
import io.intino.alexandria.zit.Zit;
import io.intino.alexandria.zit.model.Data;
import io.intino.alexandria.zit.model.Period;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ZitStream
extends ResourceIteratorStream<Data> {
    private final ItlReader reader;

    public static ZitStream of(InputStream is) throws IOException {
        return new ZitStream(ZitStream.readerOf(Zit.decompressing(is)));
    }

    public static ZitStream of(ItlReader reader) {
        return new ZitStream(reader);
    }

    public static ZitStream of(File file) throws IOException {
        return new ZitStream(ZitStream.readerOf(Zit.decompressing(ZitStream.fileInputStream(file))));
    }

    public ZitStream(ItlReader reader) {
        super(reader.data().iterator());
        this.reader = Objects.requireNonNull(reader);
    }

    public String id() {
        return this.reader.id();
    }

    public String sensor() {
        return this.reader.sensor();
    }

    public Period period() {
        return this.reader.period();
    }

    public String[] measurements() {
        return this.reader.measurements();
    }

    private static ItlReader readerOf(InputStream is) {
        return new ItlReader(is);
    }

    private static BufferedInputStream fileInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }
}

