/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal.remotedatalake;

import com.google.gson.JsonArray;
import io.intino.alexandria.Json;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor;
import io.intino.alexandria.terminal.remotedatalake.measurement.RemoteMeasurementTank;
import io.intino.alexandria.terminal.remotedatalake.message.RemoteMessageTank;
import io.intino.alexandria.terminal.remotedatalake.resource.RemoteResourceTank;
import jakarta.jms.Message;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class RemoteDatalake
implements Datalake {
    private final DatalakeAccessor accessor;

    public RemoteDatalake(JmsConnector connector) {
        this.accessor = new DatalakeAccessor(connector);
    }

    @Override
    public Datalake.Store<MessageEvent> messageStore() {
        return new Datalake.Store<MessageEvent>(){

            @Override
            public Stream<Datalake.Store.Tank<MessageEvent>> tanks() {
                Message response = RemoteDatalake.this.accessor.query("messageStore/tanks");
                if (response == null) {
                    return Stream.empty();
                }
                JsonArray content = Json.fromString(MessageReader.textFrom(response), JsonArray.class);
                return StreamSupport.stream(content.spliterator(), false).map(o -> new RemoteMessageTank(RemoteDatalake.this.accessor, o.getAsJsonObject()));
            }

            @Override
            public Datalake.Store.Tank<MessageEvent> tank(String name) {
                return this.tanks().filter(t2 -> t2.name().equals(name)).findFirst().orElse(null);
            }
        };
    }

    @Override
    public Datalake.Store<MeasurementEvent> measurementStore() {
        return new Datalake.Store<MeasurementEvent>(){

            @Override
            public Stream<Datalake.Store.Tank<MeasurementEvent>> tanks() {
                Message response = RemoteDatalake.this.accessor.query("measurementStore/tanks");
                if (response == null) {
                    return Stream.empty();
                }
                JsonArray content = Json.fromString(MessageReader.textFrom(response), JsonArray.class);
                return StreamSupport.stream(content.spliterator(), false).map(o -> new RemoteMeasurementTank(RemoteDatalake.this.accessor, o.getAsJsonObject()));
            }

            @Override
            public Datalake.Store.Tank<MeasurementEvent> tank(String name) {
                return this.tanks().filter(t2 -> t2.name().equals(name)).findFirst().orElse(null);
            }
        };
    }

    @Override
    public Datalake.ResourceStore resourceStore() {
        return new Datalake.ResourceStore(){

            @Override
            public Optional<ResourceEvent> find(ResourceEvent.REI rei) {
                return Optional.empty();
            }

            @Override
            public Stream<Datalake.Store.Tank<ResourceEvent>> tanks() {
                Message response = RemoteDatalake.this.accessor.query("resourceStore/tanks");
                if (response == null) {
                    return Stream.empty();
                }
                JsonArray content = Json.fromString(MessageReader.textFrom(response), JsonArray.class);
                return StreamSupport.stream(content.spliterator(), false).map(o -> new RemoteResourceTank(RemoteDatalake.this.accessor, o.getAsJsonObject()));
            }

            @Override
            public Datalake.Store.Tank<ResourceEvent> tank(String name) {
                return this.tanks().filter(t2 -> t2.name().equals(name)).findFirst().orElse(null);
            }
        };
    }
}

