/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.terminal;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class OutBox {
    protected final File directory;
    protected final List<File> files;

    public OutBox(File directory) {
        this.directory = directory.getAbsoluteFile();
        this.files = new CopyOnWriteArrayList<File>();
        if (!directory.exists()) {
            directory.mkdirs();
        } else {
            this.reloadOutBox();
        }
    }

    void pop() {
        this.reloadOutBox();
        if (this.files.isEmpty()) {
            return;
        }
        File file = this.files.get(0);
        file.delete();
        this.files.remove(0);
    }

    boolean isEmpty() {
        return this.reloadOutBox().isEmpty();
    }

    protected abstract String destination(File var1);

    protected synchronized List<File> reloadOutBox() {
        if (this.files.isEmpty()) {
            Collections.addAll(this.files, Objects.requireNonNull(this.directory.listFiles(f -> f.getName().endsWith(this.extension()))));
            this.files.sort(Comparator.comparingLong(File::lastModified));
        }
        return this.files;
    }

    protected abstract String extension();
}

