/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.scheduler.directory;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.directory.DirectoryTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DirectorySentinel {
    private DirectoryTask task;
    private Map<File, WatchService> watchers;
    private Thread thread;
    private boolean closed = false;

    public DirectorySentinel(File directory, DirectoryTask task, Event ... events) {
        try {
            this.task = task;
            this.watchers = new HashMap<File, WatchService>();
            this.watchers.put(directory, FileSystems.getDefault().newWatchService());
            directory.toPath().register(this.watchers.get(directory), this.kindsOf(events));
            if (directory.isDirectory() && directory.exists()) {
                for (File subDir : directory.listFiles(f -> f.isDirectory())) {
                    this.watchers.put(subDir, FileSystems.getDefault().newWatchService());
                    subDir.toPath().register(this.watchers.get(subDir), this.kindsOf(events));
                }
            }
            this.buildTask(task);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buildTask(DirectoryTask task) {
        this.thread = new Thread(() -> {
            block2: while (!this.closed) {
                for (Map.Entry<File, WatchService> entry : this.watchers.entrySet()) {
                    try {
                        WatchKey key = entry.getValue().poll(1L, TimeUnit.SECONDS);
                        if (key == null) continue;
                        Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                        while (iterator.hasNext()) {
                            WatchEvent<?> event;
                            WatchEvent<?> ev = event = iterator.next();
                            new Thread(() -> task.execute(new File((File)entry.getKey(), ((Path)ev.context()).toString()), this.eventOf(ev.kind()))).start();
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                        continue block2;
                    }
                    catch (InterruptedException | ClosedWatchServiceException ex) {
                        Logger.error(ex);
                        return;
                    }
                }
            }
        });
    }

    public void watch() {
        this.thread.start();
    }

    public void stop() {
        try {
            for (WatchService w : this.watchers.values()) {
                w.close();
            }
            this.closed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private WatchEvent.Kind[] kindsOf(Event[] events) {
        ArrayList<WatchEvent.Kind<Path>> list = new ArrayList<WatchEvent.Kind<Path>>();
        for (Event event : events) {
            if (event.equals((Object)Event.OnCreate)) {
                list.add(StandardWatchEventKinds.ENTRY_CREATE);
                continue;
            }
            if (event.equals((Object)Event.OnModify)) {
                list.add(StandardWatchEventKinds.ENTRY_MODIFY);
                continue;
            }
            if (!event.equals((Object)Event.OnDelete)) continue;
            list.add(StandardWatchEventKinds.ENTRY_DELETE);
        }
        return list.toArray(new WatchEvent.Kind[list.size()]);
    }

    private Event eventOf(WatchEvent.Kind kind) {
        if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
            return Event.OnCreate;
        }
        if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
            return Event.OnModify;
        }
        return Event.OnDelete;
    }

    public static enum Event {
        OnCreate,
        OnModify,
        OnDelete;

    }
}

