/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class MessageWriter
implements AutoCloseable {
    private final BufferedWriter writer;

    public MessageWriter(OutputStream os) {
        this(os, Charset.defaultCharset());
    }

    public MessageWriter(OutputStream os, Charset charset) {
        this.writer = new BufferedWriter(new OutputStreamWriter(os, charset));
    }

    public void write(Message message) throws IOException {
        this.writer.write(message.toString());
        this.writer.newLine();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

