/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.MessageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageStream
implements Iterator<String>,
AutoCloseable {
    private final BufferedReader reader;
    private final StringBuilder buffer;

    public MessageStream(InputStream stream) {
        this(stream, Charset.defaultCharset());
    }

    public MessageStream(InputStream stream, Charset charset) {
        this.reader = new BufferedReader(new InputStreamReader(stream, charset));
        this.buffer = new StringBuilder(64);
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.length() != 0;
    }

    @Override
    public String next() {
        try {
            String next;
            if (this.buffer.length() == 0) {
                return null;
            }
            while ((next = this.reader.readLine()) != null && MessageStream.isNotANewMessage(next)) {
                this.buffer.append(next).append('\n');
            }
            String message = this.buffer.toString();
            this.saveNextLineForLaterOrCloseReader(next);
            return message;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private void saveNextLineForLaterOrCloseReader(String next) throws IOException {
        this.buffer.setLength(0);
        if (next != null) {
            this.buffer.append(next).append('\n');
        } else {
            this.reader.close();
        }
    }

    public List<String> nextLines() {
        try {
            String next;
            if (this.buffer.length() == 0) {
                return new ArrayList<String>(0);
            }
            ArrayList<String> lines = new ArrayList<String>();
            this.setFirstLine(lines);
            while ((next = this.reader.readLine()) != null && MessageStream.isNotANewMessage(next)) {
                lines.add(next);
            }
            this.saveNextLineForLaterOrCloseReader(next);
            return lines;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private void setFirstLine(List<String> lines) {
        this.buffer.setLength(this.buffer.length() - 1);
        lines.add(this.buffer.toString());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static boolean isNotANewMessage(String next) {
        return next.isEmpty() || next.charAt(0) != '[';
    }

    private void init() {
        try {
            String line = this.getFirstLineNonBlank();
            if (line != null) {
                this.buffer.append(line).append('\n');
            } else {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getFirstLineNonBlank() throws IOException {
        String line = this.reader.readLine();
        while (line != null && line.isBlank()) {
            line = this.reader.readLine();
        }
        return line;
    }
}

