/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.DataValue;
import io.intino.alexandria.message.NullValue;
import io.intino.alexandria.message.Parser;
import io.intino.alexandria.message.ParserFactory;
import java.lang.reflect.Array;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Message {
    static final char ListSep = '\u0001';
    static final String ListSepStr = String.valueOf('\u0001');
    static final char MultilineSep = '\u0002';
    static final String MultilineSepStr = String.valueOf('\u0002');
    static final String Null = "\u0000";
    private final Map<String, String> attributes;
    private final String type;
    private Message owner;
    private List<Message> components;
    private static final Pattern MultilinePattern = Pattern.compile("\r?\n");
    private static final String ListSepStr2 = ListSepStr + ListSepStr;

    public Message(String type) {
        this.type = Objects.requireNonNull(type, "Message type cannot be null");
        this.attributes = new LinkedHashMap<String, String>();
    }

    public String type() {
        return this.type;
    }

    public boolean is(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    public boolean isComponent() {
        return this.type.indexOf(46) >= 0;
    }

    public boolean isComponentOf(String type) {
        return this.isComponent() && this.type.startsWith(type);
    }

    public List<String> attributes() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public boolean contains(String attribute) {
        return this.attributes.containsKey(attribute);
    }

    public Value get(String attribute) {
        return this.contains(attribute) ? new DataValue(this.deserialize(this.attributes.get(attribute))) : Value.Null;
    }

    public Message set(String attribute, Object value) {
        if (value == null) {
            return this.set(attribute, Null);
        }
        if (this.isIterable(value.getClass())) {
            return this.setIterable(attribute, value);
        }
        this.checkElementTypeIsSupported(value);
        return this.set(attribute, this.str(value));
    }

    private Message setIterable(String attribute, Object value) {
        this.attributes.put(attribute, this.serializedListFromIterable(value));
        return this;
    }

    public Message set(String attribute, String value) {
        this.attributes.put(attribute, this.serialize(value));
        return this;
    }

    void setUnsafe(String attribute, String value) {
        this.attributes.put(attribute, value);
    }

    private String serialize(String value) {
        if (value == null) {
            return Null;
        }
        return MultilinePattern.matcher(value).replaceAll(MultilineSepStr);
    }

    private String deserialize(String value) {
        if (Null.equals(value)) {
            return null;
        }
        return value.replace('\u0002', '\n');
    }

    public Message append(String attribute, Object value) {
        if (value == null) {
            return this.append(attribute, Null);
        }
        if (this.isIterable(value.getClass())) {
            return this.appendIterable(attribute, value);
        }
        this.checkElementTypeIsSupported(value);
        return this.append(attribute, this.str(value));
    }

    private Message appendIterable(String attribute, Object value) {
        return this.append(attribute, this.serializedListFromIterable(value));
    }

    public Message append(String attribute, String newValue) {
        if (!this.contains(attribute)) {
            return this.set(attribute, newValue);
        }
        String oldValue = this.attributes.putIfAbsent(attribute, newValue = this.serialize(newValue));
        if (oldValue == null || oldValue.isEmpty() || oldValue.equals(ListSepStr)) {
            this.attributes.put(attribute, newValue);
        } else {
            this.attributes.put(attribute, oldValue + ListSepStr + newValue);
        }
        return this;
    }

    public Message rename(String attribute, String newName) {
        this.attributes.put(newName, this.attributes.remove(attribute));
        return this;
    }

    public Message remove(String attribute) {
        this.attributes.remove(attribute);
        return this;
    }

    public Message remove(String attribute, Object value) {
        String str = value == null ? Null : this.str(value);
        this.attributes.computeIfPresent(attribute, (k, v) -> v.replace(str, "").replace(ListSepStr2, ListSepStr));
        return this;
    }

    public List<Message> components() {
        return this.components == null ? new ArrayList<Message>(0) : new ArrayList<Message>(this.components);
    }

    public List<Message> components(String type) {
        return this.components == null ? new ArrayList<Message>(0) : this.components.stream().filter(c -> c.is(type)).collect(Collectors.toList());
    }

    public void add(Message component) {
        if (component == null) {
            throw new NullPointerException("Component cannot be null");
        }
        if (this.components == null) {
            this.components = new ArrayList<Message>();
        }
        this.components.add(component);
        component.owner = this;
    }

    public void add(List<Message> components) {
        if (components == null) {
            return;
        }
        if (this.components == null) {
            this.components = new ArrayList<Message>(components.size());
        }
        components.forEach(this::add);
    }

    public void remove(Message component) {
        if (component == null) {
            return;
        }
        this.components.remove(component);
    }

    public void remove(List<Message> components) {
        if (components == null) {
            return;
        }
        this.components.removeAll(components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.qualifiedType()).append("]\n");
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            sb.append(this.stringOf(attribute)).append("\n");
        }
        for (Message component : this.components()) {
            sb.append("\n").append(component.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        return Objects.equals(this.type, message.type) && this.attributes.keySet().stream().allMatch(k -> this.attributeEquals(message, (String)k)) && Objects.equals(this.components, message.components);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.attributes, this.components);
    }

    private String stringOf(Map.Entry<String, String> attribute) {
        return attribute.getKey() + ":" + (String)(this.isMultiline(attribute.getValue()) ? Message.indent(attribute.getValue()) : " " + attribute.getValue());
    }

    private boolean isMultiline(String value) {
        return value != null && value.contains("\n");
    }

    private String qualifiedType() {
        return this.owner != null ? this.owner.qualifiedType() + "." + this.type : this.type;
    }

    private boolean isIterable(Class<?> type) {
        return Iterable.class.isAssignableFrom(type) || type.isArray();
    }

    private Iterator<?> iteratorOf(Object value) {
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).iterator();
        }
        return this.iteratorFromArray(value);
    }

    private Iterator<?> iteratorFromArray(final Object array) {
        return new Iterator<Object>(){
            private final int length;
            private int index;
            {
                this.length = Array.getLength(array);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.length;
            }

            @Override
            public Object next() {
                return Array.get(array, this.index++);
            }
        };
    }

    private String serializedListFromIterable(Object value) {
        StringBuilder list = new StringBuilder();
        Iterator<?> iterator = this.iteratorOf(value);
        while (iterator.hasNext()) {
            Object item = iterator.next();
            this.checkElementTypeIsSupported(item);
            list.append((Object)(item == null ? Null : item)).append('\u0001');
        }
        int length = list.length();
        if (length > 1) {
            list.setLength(length - 1);
        }
        return list.toString();
    }

    private void checkElementTypeIsSupported(Object value) {
        if (value == null) {
            return;
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Message does not support multidimensional arrays values");
        }
        if (Parser.of(clazz) == null) {
            throw new IllegalArgumentException("Message does not support values of type " + clazz);
        }
    }

    private String str(Object value) {
        return String.valueOf(value);
    }

    private boolean attributeEquals(Message message, String key) {
        return message.contains(key) && Objects.equals(message.get(key).data(), this.get(key).data());
    }

    private static String indent(String text) {
        return "\n\t" + text.replaceAll("\\n", "\n\t");
    }

    public static Set<String> invalidCharacters() {
        return Set.of(Null, ListSepStr, MultilineSepStr);
    }

    public static interface Value {
        public static final Value Null = new NullValue();

        public boolean isEmpty();

        default public boolean isNull() {
            return this.data() == null;
        }

        public String data();

        default public <T> boolean is(Class<T> type) {
            return this.asOptional(type).isPresent();
        }

        public <T> T as(Class<T> var1);

        default public Boolean asBoolean() {
            Boolean v = this.as(Boolean.class);
            return v != null && v != false;
        }

        default public Byte asByte() {
            return this.as(Byte.class);
        }

        default public Character asCharacter() {
            return this.as(Character.class);
        }

        default public Short asShort() {
            return this.as(Short.class);
        }

        default public Integer asInteger() {
            return this.as(Integer.class);
        }

        default public Long asLong() {
            return this.as(Long.class);
        }

        default public Float asFloat() {
            return this.as(Float.class);
        }

        default public Double asDouble() {
            return this.as(Double.class);
        }

        default public String asString() {
            return this.as(String.class);
        }

        default public Instant asInstant() {
            return this.as(Instant.class);
        }

        default public LocalTime asLocalTime() {
            return this.as(LocalTime.class);
        }

        default public LocalDate asLocalDate() {
            return this.as(LocalDate.class);
        }

        default public LocalDateTime asLocalDateTime() {
            return this.as(LocalDateTime.class);
        }

        default public String[] asMultiline() {
            return this.data().split("\n", -1);
        }

        default public Optional<String> asOptional() {
            return this.isEmpty() || this.isNull() || this.data().isEmpty() ? Optional.empty() : Optional.ofNullable(this.data());
        }

        default public <T> Optional<T> asOptional(Class<T> type) {
            try {
                return this.isEmpty() || this.isNull() || this.data().isEmpty() ? Optional.empty() : Optional.ofNullable(this.as(type));
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
        }

        default public <T> T orElse(Class<T> type, T valueIfFail) {
            return this.asOptional(type).orElse(valueIfFail);
        }

        default public Stream<String> stream() {
            return this.asOptional().stream();
        }

        default public <T> Stream<T> stream(Class<T> type) {
            return this.asOptional(type).stream();
        }

        default public <T> Stream<T> flatMap(Class<T> type) {
            if (type.isPrimitive()) {
                throw new IllegalArgumentException("Cannot flatMap primitive type: " + type);
            }
            return type.isArray() ? this.stream(type) : this.stream(ParserFactory.arrayTypeOf(type)).flatMap(Arrays::stream);
        }

        default public <T> List<T> asList(Class<T> elementType) {
            return this.collect(elementType, Collectors.toList());
        }

        default public <T> Set<T> asSet(Class<T> elementType) {
            return this.collect(elementType, Collectors.toSet());
        }

        default public <T, R> R collect(Class<T> elementType, Collector<T, ?, R> collector) {
            if (elementType.isPrimitive()) {
                throw new IllegalArgumentException("Cannot collect primitive type: " + elementType);
            }
            return this.stream(ParserFactory.arrayTypeOf(elementType)).flatMap(Arrays::stream).collect(collector);
        }
    }
}

