/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageException;
import io.intino.alexandria.message.MessageStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class LegacyMessageReader
implements Iterator<Message>,
Iterable<Message>,
AutoCloseable {
    private static final String MULTILINE_ATTRIBUTE_PREFIX = "\t";
    private final MessageStream messageStream;
    private final Message[] contextList;
    private List<String> lines;

    public LegacyMessageReader(String str) {
        this(new ByteArrayInputStream(str.getBytes()), new Config());
    }

    public LegacyMessageReader(String str, Config config) {
        this(new ByteArrayInputStream(str.getBytes()), config);
    }

    public LegacyMessageReader(InputStream inputStream) {
        this(new MessageStream(inputStream), new Config());
    }

    public LegacyMessageReader(InputStream inputStream, Config config) {
        this(new MessageStream(inputStream), config);
    }

    public LegacyMessageReader(MessageStream messageStream) {
        this(messageStream, new Config());
    }

    public LegacyMessageReader(MessageStream messageStream, Config config) {
        this.messageStream = messageStream;
        this.contextList = new Message[Math.max(config.contextMaxLevels, 1)];
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.lines != null && this.lines.size() > 0;
    }

    @Override
    public Message next() {
        try {
            return this.hasNext() ? this.nextMessage() : null;
        }
        catch (MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }

    @Override
    public void close() throws Exception {
        try {
            this.messageStream.close();
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    private Message nextMessage() {
        this.parse(this.lines, this.contextList);
        while ((this.lines = this.messageStream.nextLines()).size() > 0 && this.isComponent(this.lines.get(0))) {
            this.parse(this.lines, this.contextList);
        }
        return this.firstNonNullAndReset(this.contextList);
    }

    private void parse(List<String> lines, Message[] contextList) {
        String type = this.typeOf(lines.get(0));
        String[] context = type.split("\\.", -1);
        int level = context.length - 1;
        Message message = new Message(context[level]);
        if (level > 0 && contextList[level - 1] != null) {
            contextList[level - 1].add(message);
        }
        contextList[level] = message;
        this.readAttributes(message, lines);
    }

    private void readAttributes(Message message, List<String> lines) {
        int size = lines.size();
        for (int i = 1; i < size; ++i) {
            String line = lines.get(i);
            try {
                int attribSep = line.indexOf(58);
                if (attribSep < 0) continue;
                String name = this.nameOf(line, attribSep);
                String value = this.valueOf(line, attribSep);
                if (this.isLegacyMultilineAttribute(value, i, lines)) {
                    i = LegacyMessageReader.readLegacyMultilineAttribute(message, lines, size, i, name);
                    continue;
                }
                message.setUnsafe(name, value);
                continue;
            }
            catch (Exception e) {
                throw new MessageException("Malformed message attribute at line " + i + ": " + line, e);
            }
        }
    }

    private String valueOf(String line, int attribSep) {
        int start = line.indexOf(32, attribSep + 1);
        return line.substring(start < 0 ? attribSep + 1 : start + 1);
    }

    private String nameOf(String line, int attribSep) {
        return line.substring(0, attribSep);
    }

    private boolean isLegacyMultilineAttribute(String value, int i, List<String> lines) {
        return value.isEmpty() && i < lines.size() - 1 && lines.get(i + 1).startsWith(MULTILINE_ATTRIBUTE_PREFIX);
    }

    private static int readLegacyMultilineAttribute(Message message, List<String> lines, int size, int i, String name) {
        StringBuilder multilineValue = new StringBuilder(128);
        ++i;
        while (i < size) {
            String line = lines.get(i);
            if (!line.startsWith(MULTILINE_ATTRIBUTE_PREFIX)) {
                LegacyMessageReader.setMultilineAttribute(message, name, multilineValue);
                return i - 1;
            }
            multilineValue.append(line.substring(1)).append('\n');
            ++i;
        }
        LegacyMessageReader.setMultilineAttribute(message, name, multilineValue);
        return i;
    }

    private static void setMultilineAttribute(Message message, String name, StringBuilder multilineValue) {
        multilineValue.setLength(Math.max(0, multilineValue.length() - 1));
        message.set(name, multilineValue.toString());
    }

    private String typeOf(String line) {
        return line.substring(1, line.lastIndexOf(93));
    }

    private boolean isComponent(String next) {
        return next.indexOf(46) > 0;
    }

    private Message firstNonNullAndReset(Message[] messages) {
        Message message = null;
        for (int i = 0; i < messages.length; ++i) {
            Message m = messages[i];
            if (m != null && message == null) {
                message = m;
            }
            messages[i] = null;
        }
        if (message == null) {
            throw new NoSuchElementException("No messages left");
        }
        return message;
    }

    private void init() {
        if (this.messageStream.hasNext()) {
            this.lines = this.messageStream.nextLines();
        }
    }

    public static class Config {
        private int linesBufferSize = 128;
        private int contextMaxLevels = 8;

        public Config linesBufferSize(int linesBufferSize) {
            this.linesBufferSize = linesBufferSize;
            return this;
        }

        public Config contextMaxLevels(int contextMaxLevels) {
            this.contextMaxLevels = contextMaxLevels;
            return this;
        }
    }
}

