/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.jms.JmsConsumer;
import io.intino.alexandria.logger.Logger;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.activemq.ActiveMQSession;

public class DurableTopicConsumer
extends JmsConsumer {
    protected List<Consumer<Message>> listeners;
    private final String subscriberId;

    public DurableTopicConsumer(Session session, String topic, String subscriberId) throws JMSException {
        this(session, topic, null, subscriberId);
    }

    public DurableTopicConsumer(Session session, String topic, String messageSelector, String subscriberId) throws JMSException {
        super(session, session.createTopic(topic));
        this.subscriberId = subscriberId;
        this.listeners = new ArrayList<Consumer<Message>>();
        try {
            this.consumer = session.createDurableSubscriber((Topic)this.destination, subscriberId, messageSelector, true);
        }
        catch (JMSException ex) {
            Logger.error(ex);
        }
    }

    public String subscriberId() {
        return this.subscriberId;
    }

    public void destroy() {
        try {
            if (this.consumer == null) {
                return;
            }
            this.consumer.close();
            if (this.subscriberId != null && !((ActiveMQSession)this.session).isClosed()) {
                this.session.unsubscribe(this.subscriberId);
            }
        }
        catch (InvalidDestinationException invalidDestinationException) {
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }
}

