/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event.resource;

import io.intino.alexandria.Resource;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.event.resource.ResourceEvent;
import io.intino.alexandria.event.resource.ZipResourceReader;
import io.intino.alexandria.resourcecleaner.DisposableResource;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ResourceEventReader
implements EventReader<ResourceEvent> {
    private final Iterator<ResourceEvent> iterator;

    public ResourceEventReader(File file) throws IOException {
        this(new ResourceToEventIterator(new ZipResourceReader(file)));
    }

    public ResourceEventReader(ResourceEvent ... events) {
        this(Arrays.stream(events));
    }

    public ResourceEventReader(List<ResourceEvent> events) {
        this(events.stream());
    }

    public ResourceEventReader(Stream<ResourceEvent> stream) {
        this(stream.sorted().iterator());
    }

    public ResourceEventReader(Iterator<ResourceEvent> iterator) {
        this.iterator = iterator;
    }

    @Override
    public void close() throws Exception {
        if (this.iterator instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.iterator)).close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ResourceEvent next() {
        return this.iterator.next();
    }

    public static class ResourceToEventIterator
    implements Iterator<ResourceEvent>,
    AutoCloseable {
        private final Iterator<Resource> iterator;

        public ResourceToEventIterator(Iterator<Resource> iterator) {
            DisposableResource.whenDestroyed(this).thenClose(iterator);
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ResourceEvent next() {
            return ResourceEvent.of(this.iterator.next());
        }

        @Override
        public void close() throws Exception {
            if (this.iterator instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.iterator)).close();
            }
        }
    }
}

