/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEventWriter;
import io.intino.alexandria.event.message.MessageEventWriter;
import io.intino.alexandria.event.resource.ResourceEventWriter;
import io.intino.alexandria.logger.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public interface EventWriter<T extends Event>
extends AutoCloseable {
    public static <T extends Event> EventWriter<T> of(File file) throws IOException {
        return EventWriter.of(file, false);
    }

    public static <T extends Event> EventWriter<T> of(Event.Format format, File file) throws IOException {
        return EventWriter.of(format, file, false);
    }

    public static <T extends Event> EventWriter<T> of(File file, boolean append) throws IOException {
        return EventWriter.of(Event.Format.of(file), file, append);
    }

    public static <T extends Event> EventWriter<T> of(Event.Format format, File file, boolean append) throws IOException {
        switch (format) {
            case Message: {
                return new MessageEventWriter(file, append);
            }
            case Measurement: {
                return new MeasurementEventWriter(file, append);
            }
            case Resource: {
                return new ResourceEventWriter(file);
            }
        }
        Logger.error("Unknown event format " + String.valueOf((Object)Event.Format.of(file)));
        return new Empty();
    }

    public static <T extends Event> EventWriter<T> of(Event.Format format, OutputStream outputStream) throws IOException {
        switch (format) {
            case Message: {
                return new MessageEventWriter(outputStream);
            }
            case Measurement: {
                return new MeasurementEventWriter(outputStream);
            }
            case Resource: {
                Logger.error("Resource event format not supported for outputStream");
            }
        }
        Logger.error("Unknown event format " + String.valueOf((Object)format));
        return new Empty();
    }

    public static <T extends Event> void append(File file, Stream<T> events) throws IOException {
        EventWriter.write(file, true, events);
    }

    public static <T extends Event> void append(File file, Collection<T> events) throws IOException {
        EventWriter.write(file, true, events.stream());
    }

    public static <T extends Event> void write(File file, Stream<T> events) throws IOException {
        EventWriter.write(file, false, events);
    }

    public static <T extends Event> void write(File file, boolean append, Collection<T> events) throws IOException {
        EventWriter.write(file, append, events.stream());
    }

    public static <T extends Event> void write(File file, boolean append, Stream<T> events) throws IOException {
        try (EventWriter<T> writer = EventWriter.of(file, append);){
            writer.write(events);
        }
    }

    public static <T extends Event> void write(Event.Format format, OutputStream destination, Collection<T> events) throws IOException {
        EventWriter.write(format, destination, events.stream());
    }

    public static <T extends Event> void write(Event.Format format, OutputStream destination, Stream<T> events) throws IOException {
        try (EventWriter<T> writer = EventWriter.of(format, destination);){
            writer.write(events);
        }
    }

    public void write(T var1) throws IOException;

    default public void write(Stream<T> stream) throws IOException {
        try (Stream<T> stream2 = stream;){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                this.write((Event)iterator.next());
            }
        }
    }

    default public void write(Collection<T> messages) throws IOException {
        this.write(messages.stream());
    }

    public void flush() throws IOException;

    @Override
    public void close() throws IOException;

    public static class Empty<T extends Event>
    implements EventWriter<T> {
        @Override
        public void write(T event) {
        }

        @Override
        public void write(Stream<T> stream) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    public static class IO {
        public static OutputStream open(File file, boolean append) throws IOException {
            return new FileBufferedOutputStream(new FileOutputStream(file, append));
        }

        public static class FileBufferedOutputStream
        extends BufferedOutputStream {
            public FileBufferedOutputStream(FileOutputStream out) {
                super(out);
            }
        }
    }
}

