/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEventReader;
import io.intino.alexandria.event.message.MessageEventReader;
import io.intino.alexandria.event.resource.ResourceEventReader;
import io.intino.alexandria.logger.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public interface EventReader<T extends Event>
extends Iterator<T>,
AutoCloseable {
    public static <T extends Event> EventReader<T> of(File file) throws IOException {
        return EventReader.of(Event.Format.of(file), file);
    }

    public static <T extends Event> EventReader<T> of(Event.Format format, File file) throws IOException {
        if (!file.exists()) {
            return new Empty();
        }
        switch (format) {
            case Message: {
                return new MessageEventReader(file);
            }
            case Measurement: {
                return new MeasurementEventReader(file);
            }
            case Resource: {
                return new ResourceEventReader(file);
            }
        }
        Logger.error("Unknown event format " + String.valueOf((Object)Event.Format.of(file)));
        return new Empty();
    }

    public static <T extends Event> EventReader<T> of(Event.Format format, InputStream inputStream) throws IOException {
        switch (format) {
            case Message: {
                return new MessageEventReader(inputStream);
            }
            case Measurement: {
                return new MeasurementEventReader(inputStream);
            }
            case Resource: {
                Logger.error("Resource event format not supported for outputStream");
            }
        }
        Logger.error("Unknown event format " + String.valueOf((Object)format));
        return new Empty();
    }

    public static class Empty<T extends Event>
    implements EventReader<T> {
        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }
    }

    public static class IO {
        public static InputStream open(File file) throws IOException {
            return new BufferedInputStream(new FileInputStream(file));
        }
    }
}

