/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.datalake.file.measurement;

import io.intino.alexandria.FS;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.measurement.MeasurementEventTub;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MeasurementEventSource
implements Datalake.Store.Source<MeasurementEvent> {
    private final File root;

    public MeasurementEventSource(File file) {
        this.root = file;
    }

    @Override
    public String name() {
        return this.root.getName();
    }

    @Override
    public Datalake.Store.Tub<MeasurementEvent> tub(Timetag timetag) {
        File file = new File(this.root, timetag.value() + Event.Format.Measurement.extension());
        return file.exists() ? new MeasurementEventTub(file) : null;
    }

    @Override
    public Scale scale() {
        return Optional.ofNullable(this.first()).map(Datalake.Store.Tub::scale).orElse(null);
    }

    @Override
    public Datalake.Store.Tub<MeasurementEvent> first() {
        return this.tubs().findFirst().orElse(null);
    }

    @Override
    public Datalake.Store.Tub<MeasurementEvent> last() {
        List files = this.tubFiles().collect(Collectors.toList());
        return files.isEmpty() ? null : new MeasurementEventTub((File)files.get(files.size() - 1));
    }

    @Override
    public Stream<Datalake.Store.Tub<MeasurementEvent>> tubs() {
        return this.tubFiles().map(MeasurementEventTub::new);
    }

    @Override
    public Datalake.Store.Tub<MeasurementEvent> on(Timetag tag) {
        return new MeasurementEventTub(new File(this.root, tag.value() + Event.Format.Measurement.extension()));
    }

    private Stream<File> tubFiles() {
        return FS.filesIn(this.root, pathname -> pathname.getName().endsWith(Event.Format.Measurement.extension()));
    }
}

