/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import java.io.File;

public class Fingerprint {
    private static final String SEPARATOR = "/";
    private static final String NAME_SEPARATOR = "~";
    private final String fingerprint;

    public Fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public static Fingerprint of(String tank, String source, Timetag timetag, Event.Format format) {
        return new Fingerprint(tank + SEPARATOR + source + SEPARATOR + String.valueOf(timetag) + SEPARATOR + String.valueOf((Object)format));
    }

    public static Fingerprint of(File file) {
        return new Fingerprint(Fingerprint.cleanedNameOf(file));
    }

    public String tank() {
        return this.fingerprint.split(SEPARATOR)[0];
    }

    public String source() {
        return this.fingerprint.split(SEPARATOR)[1];
    }

    public Timetag timetag() {
        return new Timetag(this.fingerprint.split(SEPARATOR)[2]);
    }

    public Event.Format format() {
        try {
            return Event.Format.valueOf(Fingerprint.firstUpperCase(this.fingerprint.split(SEPARATOR)[3]));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public String name() {
        return this.fingerprint.replace(SEPARATOR, NAME_SEPARATOR);
    }

    public String toString() {
        return this.fingerprint;
    }

    public boolean equals(Object o) {
        return this.fingerprint.equals(o.toString());
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    private static String cleanedNameOf(File file) {
        String name = file.getName();
        if (name.contains("#")) {
            name = name.substring(0, name.lastIndexOf("#"));
        }
        return name.replace(NAME_SEPARATOR, SEPARATOR).replace(".session", "");
    }

    public static String firstUpperCase(String value) {
        return value.isEmpty() ? "" : value.substring(0, 1).toUpperCase() + value.substring(1);
    }
}

