package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.framework.Activity;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;

import java.io.File;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;

public class RunScriptRequest extends ContainerRequest {
	public static final String ID = "runScript";
	private final ContainerBox box;
	private final Activity.Context context;
	private final ContainerStore store;

	public RunScriptRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
		this.context = context;
		this.store = store;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		BytesMessage message = (BytesMessage) request;
		try {
			String filename = parameter(request, "filename");
			String directory = parameter(request, "directory");
			byte[] payload = new byte[(int) message.getBodyLength()];
			message.readBytes(payload);
			File file = new File(store.workingDirectory(), filename);
			file.getParentFile().mkdirs();
			Files.write(file.toPath(), payload);
			Process start = new ProcessBuilder(file.getAbsolutePath()).directory(directory != null ? new File(directory) : store.workingDirectory()).start();
			start.waitFor(10, TimeUnit.SECONDS);
			return new RequestResult(true, new String(start.getInputStream().readAllBytes()));
		} catch (Throwable e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}