package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.utils.Utils;
import jakarta.jms.Message;

import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

import static io.intino.consul.container.box.actions.WindowsUpgradeCommand.UPGRADE_BAT;
import static io.intino.consul.container.box.actions.WindowsUpgradeCommand.createScript;

public class RestartConsulRequest extends ContainerRequest {

	public static final String ID = "restart";

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		Logger.info("Consul Restart requested");
		File jarFile = jarFile();
		String jarName = jarFile.getName().toLowerCase().replace(".jar", "");
		if (Utils.isWindows()) {
			try {
				File installDirectory = UpgradeRequest.installDirectory();
				createScript(installDirectory, UPGRADE_BAT);
				runProcessDelayed(new ProcessBuilder().directory(installDirectory).command("net", "start", "consul-upgrade"));
			} catch (IOException e) {
				Logger.error(e);
			}
		} else if (Utils.isUnix()) runProcessDelayed(new ProcessBuilder().command("systemctl", "restart", jarName));
		return new RequestResult(true, "Restarted consul");
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}

	private static void runProcessDelayed(ProcessBuilder processBuilder) {
		new Timer().schedule(new TimerTask() {
			@Override
			public void run() {
				try {
					processBuilder.inheritIO().start();
				} catch (IOException e) {
					Logger.error(e);
				}
			}
		}, 1000);
	}

	private File jarFile() {
		return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " "));
	}
}