package io.intino.consul.container.box.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.container.box.ContainerBox;
import io.intino.consul.container.box.ContainerStore;
import io.intino.consul.container.box.actions.ObserverAssertionAction;
import io.intino.consul.framework.Activity;
import jakarta.jms.Message;

public class DisableActivityRequest extends ContainerRequest {
	public static final String ID = "disableActivity";
	private final ContainerBox box;
	private final Activity.Context context;

	public DisableActivityRequest(ContainerBox box, Activity.Context context, ContainerStore store) {
		this.box = box;
		this.context = context;
	}

	@Override
	public String id() {
		return ID;
	}

	@Override
	public RequestResult responseTo(Message request) {
		try {
			String activityId = activity(request);
			if (activityId == null) return new RequestResult(false, "Activity not found");
			box.activities().disableActivity(activityId);
			new Thread(() -> new ObserverAssertionAction(box, context).execute()).start();
			return new RequestResult(true, "");
		} catch (Throwable e) {
			Logger.error(e);
			return new RequestResult(false, e.getMessage());
		}
	}

	@Override
	public boolean isAvailable(Message message) {
		return true;
	}
}